/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.client;

import de.hardcode.hq.chat.client.ChatClient;
import de.hardcode.hq.location.client.LocationsClient;
import de.hardcode.hq.objectbus.BusStation;
import de.hardcode.hq.objectbus.NetLine;
import de.hardcode.hq.objectbus.NetStation;
import de.hardcode.hq.property.client.PropertyClient;
import de.hardcode.hq.registry.client.RegistryClient;
import de.hardcode.hq.time.client.TimeClient;
import de.hardcode.time.Clock;
import de.jpilot.client.Log;
import de.jpilot.protocol.ID;
import de.jpilot.protocol.SubSystems;
import java.net.InetAddress;

public class BusStationBinding {
    private final RegistryClient mRegistryClient;
    private final LocationsClient mLocationsClient;
    private final PropertyClient mPropertyClient;
    private final ChatClient mChatClient;
    private TimeClient mTimeClient;
    private final NetStation mStation = new NetStation();
    static final /* synthetic */ boolean $assertionsDisabled;

    public BusStationBinding(SubSystems subsys) {
        this.mRegistryClient = new RegistryClient(this.mStation, ID.REGISTRY, ID.REGISTRY_SERVICE, subsys.getRegistry());
        this.mLocationsClient = new LocationsClient(this.mStation, ID.LOCATIONS, ID.LOCATIONS_SERVICE, subsys.getLocations());
        this.mPropertyClient = new PropertyClient(this.mStation, ID.PROPERTY, ID.PROPERTY_SERVICE, subsys.getProperties());
        this.mChatClient = new ChatClient(this.mStation, ID.CHAT);
    }

    public final void close() {
        this.mRegistryClient.close();
        this.mLocationsClient.close();
        this.mPropertyClient.close();
        this.mChatClient.close();
        if (null != this.mTimeClient) {
            this.mTimeClient.close();
        }
        this.mStation.close();
    }

    public BusStation getBusStation() {
        return this.mStation;
    }

    public ChatClient getChatClient() {
        return this.mChatClient;
    }

    public void download() {
        this.mLocationsClient.download();
        this.mRegistryClient.download();
        this.mPropertyClient.download();
    }

    public final boolean connect(InetAddress server, int port, Clock clk) {
        long ping = Long.MAX_VALUE;
        NetLine line = this.mStation.createLine(server, port);
        if (null != line) {
            this.mStation.startReceive();
            this.mTimeClient = new TimeClient(line, ID.TIME_SERVICE, clk);
            ping = this.mTimeClient.ping(true);
            Log.logger.info("Ping time to server is " + ping);
        } else {
            Log.logger.severe("Cannot create line to server " + server + ":" + port);
        }
        return ping < 2000L;
    }

    public void resyncClock() {
        if (!$assertionsDisabled && this.mTimeClient == null) {
            throw new AssertionError();
        }
        if (null != this.mTimeClient) {
            this.mTimeClient.ping(false);
        }
    }

    public long getLastPingValue() {
        if (!$assertionsDisabled && this.mTimeClient == null) {
            throw new AssertionError();
        }
        if (null != this.mTimeClient) {
            return this.mTimeClient.getPing();
        }
        return 0L;
    }

    static {
        $assertionsDisabled = !BusStationBinding.class.desiredAssertionStatus();
    }
}

