/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.app.server;

import de.hardcode.hq.chat.client.ChatClient;
import de.hardcode.hq.chat.client.ChatListener;
import de.hardcode.hq.chat.client.ChatMessage;
import de.hardcode.hq.chat.server.ChatServer;
import de.hardcode.hq.location.server.LocationsServer;
import de.hardcode.hq.objectbus.BroadcastServerListener;
import de.hardcode.hq.objectbus.NetStation;
import de.hardcode.hq.objectbus.ServerBusStationDriver;
import de.hardcode.hq.property.server.PropertyServerModule;
import de.hardcode.hq.registry.server.RegistryServerModule;
import de.hardcode.hq.time.server.TimeService;
import de.hardcode.time.SystemClock;
import de.jpilot.protocol.ID;
import de.jpilot.protocol.SubSystems;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Date;

public class Server {
    public static final int SERVER_DEFAULT_PORT = 13664;
    private NetStation mStation;
    private SubSystems mSubSystems = new SubSystems();
    private ChatClient mChat;
    private ChatServer mChatServer;
    private PropertyServerModule mPropertyServer;
    private RegistryServerModule mRegistryServer;
    private LocationsServer mLocationsServer;
    private TimeService mTimeService;
    private BroadcastServerListener mPublicEvents;

    public Server() {
        this(13664);
    }

    public Server(int port) {
        this.setIO();
        System.out.println("Welcome to the JPilot server!");
        this.mStation = new NetStation(port);
        if (this.mStation.isOperational()) {
            this.mStation.startReceive();
            this.setupChat();
            this.mChatServer = new ChatServer(this.mStation, ID.CHAT);
            this.mPropertyServer = new PropertyServerModule(this.mStation, ID.PROPERTY, ID.PROPERTY_SERVICE, this.mSubSystems.getProperties());
            this.mRegistryServer = new RegistryServerModule(this.mStation, ID.REGISTRY, ID.REGISTRY_SERVICE, this.mSubSystems.getRegistry());
            this.mLocationsServer = new LocationsServer(this.mStation, ID.LOCATIONS);
            this.mTimeService = new TimeService(this.mStation, ID.TIME_SERVICE, new SystemClock());
            this.mPublicEvents = new BroadcastServerListener(this.mStation, ID.PUBLIC_EVENTS);
            new ServerBusStationDriver(this.mStation);
        } else {
            System.out.println("Sorry, cannot initialize the server correctly!");
        }
    }

    public boolean isOperational() {
        return this.mStation.isOperational();
    }

    public void close() {
        System.out.println("Shutting down...good bye!");
        this.mChat.close();
        this.mPropertyServer.close();
        this.mRegistryServer.close();
        this.mLocationsServer.close();
        this.mTimeService.close();
        this.mPublicEvents.close();
        this.mStation.close();
        this.mSubSystems.close();
    }

    void setupChat() {
        this.mChat = new ChatClient(this.mStation, ID.CHAT);
        this.mChat.addListener(new ChatListener(){

            public void newMessage(ChatMessage msg) {
                System.out.println(msg.getMessage());
                Server.this.mChat.clear();
            }
        });
    }

    void operateServerInteractiv() {
        try {
            while (true) {
                BufferedReader br;
                String s;
                if ((s = (br = new BufferedReader(new InputStreamReader(System.in))).readLine()).length() <= 0) {
                    continue;
                }
                if (s.equals("quit")) {
                    this.close();
                    return;
                }
                if (s.equals("help")) {
                    System.out.println(": Commands are:");
                    System.out.println(": help\t\tGets you here.");
                    System.out.println(": quit\t\tShutdown server and exit.");
                    continue;
                }
                this.mChat.send("<server operator>", s);
                this.mStation.flush();
            }
        }
        catch (IOException ioex) {
            System.out.println("Encountered unexpected error: " + ioex);
            this.close();
            return;
        }
    }

    public void setIO() {
        try {
            System.setOut(this.setO(System.out, "out"));
            System.setErr(this.setO(System.err, "err"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private PrintStream setO(PrintStream output, String fileName) throws FileNotFoundException {
        if (fileName == null || fileName.equals("")) {
            return output;
        }
        boolean append = true;
        File outFile = new File(fileName);
        if (outFile.exists() && outFile.length() > 65535L) {
            outFile.renameTo(new File(fileName + ".old"));
            append = false;
        }
        return new PrintStream(new FileOutputStream(fileName, append)){

            public void println(String s) {
                this.print(new Date());
                this.print('\t');
                super.println(s);
            }
        };
    }

    public static void main(String[] args) {
        int port = 13664;
        if (args.length == 1) {
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                System.out.println("Argument " + args[0] + " isn't a valid port number!");
            }
        }
        Server server = new Server(port);
        server.operateServerInteractiv();
    }
}

