/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.app.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class LoginDialog
extends JDialog {
    private boolean mDoExit = false;
    private JButton mButtonConnect;
    private JButton mButtonExit;
    private JCheckBox mCheckBoxAsServer;
    private JCheckBox mCheckBoxFullscreen;
    private JPanel mMiscPanel;
    private JPanel mNetOptionsPanel;
    private JPasswordField mPasswordField;
    private JTextField mTextFieldName;
    private JTextField mTextFieldPort;
    private JTextField mTextFieldServername;
    private JPanel mUserNamePanel;

    public LoginDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.initCustom();
        this.pack();
        this.center();
    }

    private void initCustom() {
        String username = System.getProperty("user.name");
        this.mTextFieldName.setText(username);
        this.getRootPane().setDefaultButton(this.mButtonConnect);
    }

    public boolean doExit() {
        return this.mDoExit;
    }

    public boolean goFullscreen() {
        return this.mCheckBoxFullscreen.isSelected();
    }

    public String getUserName() {
        return this.mTextFieldName.getText().trim();
    }

    public void setServerName(String name) {
        this.mTextFieldServername.setText(name);
    }

    public String getServerName() {
        if (this.getIsLocalServer()) {
            return "localhost";
        }
        return this.mTextFieldServername.getText();
    }

    public int getServerPort() {
        return Integer.parseInt(this.mTextFieldPort.getText());
    }

    public boolean getIsLocalServer() {
        return this.mCheckBoxAsServer.isSelected();
    }

    private void initComponents() {
        this.mNetOptionsPanel = new JPanel();
        this.mCheckBoxAsServer = new JCheckBox();
        JLabel mServernameLabel = new JLabel();
        this.mTextFieldServername = new JTextField();
        JLabel mPortLabel = new JLabel();
        this.mTextFieldPort = new JTextField();
        this.mButtonConnect = new JButton();
        this.mUserNamePanel = new JPanel();
        JLabel mLabelName = new JLabel();
        this.mTextFieldName = new JTextField();
        JLabel mLabelPassword = new JLabel();
        this.mPasswordField = new JPasswordField();
        this.mMiscPanel = new JPanel();
        this.mCheckBoxFullscreen = new JCheckBox();
        this.mButtonExit = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("JPilot - login");
        this.setModal(true);
        this.setResizable(false);
        this.mNetOptionsPanel.setBorder(new TitledBorder("Server"));
        this.mCheckBoxAsServer.setText("as server");
        this.mCheckBoxAsServer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoginDialog.this.mCheckBoxAsServerActionPerformed(evt);
            }
        });
        this.mNetOptionsPanel.add(this.mCheckBoxAsServer);
        mServernameLabel.setText("Servername:");
        this.mNetOptionsPanel.add(mServernameLabel);
        this.mTextFieldServername.setText("localhost");
        this.mTextFieldServername.setPreferredSize(new Dimension(150, 20));
        this.mNetOptionsPanel.add(this.mTextFieldServername);
        mPortLabel.setText("Port:");
        this.mNetOptionsPanel.add(mPortLabel);
        this.mTextFieldPort.setText("13664");
        this.mTextFieldPort.setPreferredSize(new Dimension(50, 20));
        this.mNetOptionsPanel.add(this.mTextFieldPort);
        this.mButtonConnect.setText("Connect");
        this.mButtonConnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoginDialog.this.mButtonConnectActionPerformed(evt);
            }
        });
        this.mNetOptionsPanel.add(this.mButtonConnect);
        this.getContentPane().add((Component)this.mNetOptionsPanel, "Center");
        this.mUserNamePanel.setBorder(new TitledBorder("Username"));
        mLabelName.setText("Name: ");
        this.mUserNamePanel.add(mLabelName);
        this.mTextFieldName.setPreferredSize(new Dimension(150, 20));
        this.mUserNamePanel.add(this.mTextFieldName);
        mLabelPassword.setText("Password: ");
        this.mUserNamePanel.add(mLabelPassword);
        this.mPasswordField.setPreferredSize(new Dimension(150, 20));
        this.mUserNamePanel.add(this.mPasswordField);
        this.getContentPane().add((Component)this.mUserNamePanel, "North");
        this.mCheckBoxFullscreen.setText("fullscreen");
        this.mMiscPanel.add(this.mCheckBoxFullscreen);
        this.mButtonExit.setText("Exit");
        this.mButtonExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoginDialog.this.mButtonExitActionPerformed(evt);
            }
        });
        this.mMiscPanel.add(this.mButtonExit);
        this.getContentPane().add((Component)this.mMiscPanel, "South");
    }

    private void mButtonExitActionPerformed(ActionEvent evt) {
        this.mDoExit = true;
        this.hide();
    }

    private void mCheckBoxAsServerActionPerformed(ActionEvent evt) {
        if (this.mCheckBoxAsServer.isSelected()) {
            this.mTextFieldServername.setEnabled(false);
            try {
                this.mTextFieldServername.setText(InetAddress.getLocalHost().toString());
            }
            catch (UnknownHostException unknownHostException) {}
        } else {
            this.mTextFieldServername.setEnabled(true);
        }
    }

    private void mButtonConnectActionPerformed(ActionEvent evt) {
        this.mDoExit = false;
        this.hide();
    }

    private void center() {
        Dimension WindowSize = this.getSize();
        Dimension ScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((ScreenSize.width - WindowSize.width) / 2, (ScreenSize.height - WindowSize.height) / 2, WindowSize.width, WindowSize.height);
    }

    public static void main(String[] args) {
        new LoginDialog((Frame)new JFrame(), true).show();
    }
}

