/*
 * Decompiled with CFR 0.152.
 */
package de.jpilot.app.client;

import de.jpilot.app.client.Log;
import de.jpilot.app.client.LoginDialog;
import de.jpilot.app.server.Server;
import de.jpilot.client.Client;
import de.jpilot.client.UserInfo;
import de.jpilot.graphicsengine.piccolo.PiccoloEngine;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class JPilot
extends JFrame {
    private final PiccoloEngine mEngine = new PiccoloEngine(800, 600);
    private final Client mClt;
    private final LoginDialog mLogin = new LoginDialog((Frame)this, true);
    DisplayMode mDesktopMode = null;
    DisplayMode mFullscreenMode = null;
    private final ArrayList mDisplayModes = new ArrayList();
    Server mServer = null;

    public JPilot(String[] args) {
        this.initComponents();
        this.initCustom();
        this.pack();
        this.center();
        this.show();
        if (args.length == 1) {
            this.mLogin.setServerName(args[0]);
        }
        UserInfo ui = new UserInfo();
        this.mClt = new Client(this.mEngine, this.mEngine.createController(), ui);
        boolean connectSucceeded = false;
        while (!connectSucceeded) {
            this.mLogin.show();
            if (this.mLogin.doExit()) {
                this.exitForm(null);
            }
            ui.name = this.mLogin.getUserName();
            if (this.mLogin.getIsLocalServer()) {
                this.mServer = new Server(this.mLogin.getServerPort());
                if (!this.mServer.isOperational()) {
                    JOptionPane.showMessageDialog(this, "Cannot create local server!");
                    this.exitForm(null);
                }
            }
            try {
                String server = this.mLogin.getServerName().trim();
                connectSucceeded = this.mClt.connect(InetAddress.getByName(server), this.mLogin.getServerPort());
                if (connectSucceeded) continue;
                JOptionPane.showMessageDialog(this, "Cannot connect to server!");
            }
            catch (UnknownHostException uhex) {
                JOptionPane.showMessageDialog(this, "Servername invalid!");
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Exception occured while connecting: " + ex);
                ex.printStackTrace();
            }
        }
        this.handleFullscreen();
        this.mEngine.requestFocus();
    }

    private final void collectDisplayModes() {
        DisplayMode[] modes = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayModes();
        for (int i = 0; i < modes.length; ++i) {
            if (modes[i].getWidth() != 800 || modes[i].getHeight() != 600) continue;
            if (this.mFullscreenMode != null) {
                if (modes[i].getRefreshRate() >= 100 || this.mFullscreenMode.getRefreshRate() >= modes[i].getRefreshRate() && this.mFullscreenMode.getBitDepth() >= modes[i].getBitDepth()) continue;
                this.mFullscreenMode = modes[i];
                continue;
            }
            this.mFullscreenMode = modes[i];
        }
    }

    void handleFullscreen() {
        this.collectDisplayModes();
        GraphicsDevice dev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        DisplayMode mode = this.mFullscreenMode;
        if (null == mode) {
            return;
        }
        String desc = mode.getWidth() + "x" + mode.getHeight() + "x" + mode.getBitDepth() + "@" + mode.getRefreshRate();
        Log.logger.info("Using displaymode " + desc);
        if (this.mLogin.goFullscreen() && dev.isFullScreenSupported()) {
            this.dispose();
            this.setUndecorated(true);
            this.mDesktopMode = dev.getDisplayMode();
            dev.setFullScreenWindow(this);
            dev.setDisplayMode(mode);
            this.mEngine.setSize(mode.getWidth(), mode.getHeight());
        }
    }

    private void initCustom() {
        this.getContentPane().add((Component)this.mEngine, "Center");
    }

    private void initComponents() {
        this.setTitle("JPilot client - v0.2");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JPilot.this.exitForm(evt);
            }
        });
    }

    private void exitForm(WindowEvent evt) {
        if (null != this.mClt) {
            this.mClt.close();
        }
        if (null != this.mServer) {
            this.mServer.close();
        }
        System.exit(0);
    }

    private void center() {
        Dimension WindowSize = this.getSize();
        Dimension ScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((ScreenSize.width - WindowSize.width) / 2, (ScreenSize.height - WindowSize.height) / 2, WindowSize.width, WindowSize.height);
    }

    public static void main(String[] args) {
        new JPilot(args);
    }
}

