/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.util;

import javax.vecmath.Quat4f;

public class QuatUtil {
    public static final float dot(Quat4f q1, Quat4f q2) {
        return q1.x * q2.x + q1.y * q2.y + q1.z * q2.z + q1.w * q2.w;
    }

    public static boolean makeClosest(Quat4f q1, Quat4f q2) {
        if (QuatUtil.dot(q1, q2) < 0.0f) {
            q1.negate();
            return true;
        }
        return false;
    }

    public static void slerp(Quat4f q1, Quat4f q2, float t) {
        q1.normalize();
        q2.normalize();
        QuatUtil.makeClosest(q1, q2);
        q1.interpolate(q2, t);
        q1.normalize();
    }
}

