/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.util;

import de.hardcode.util.URLProvider;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class BaseDirectoryURLProvider
implements URLProvider {
    private final String mBasePath;
    private final String mProtocol = "file:";

    public BaseDirectoryURLProvider(String pathname) {
        this.mBasePath = pathname;
    }

    public URL createURL(String rel) {
        try {
            return new URL("file:" + this.mBasePath + rel);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public InputStream createStream(String rel) {
        try {
            return new FileInputStream(this.mBasePath + rel);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] argv) {
        System.out.println(new BaseDirectoryURLProvider("./data/").createURL("xml/planes.xml"));
        System.out.println(new BaseDirectoryURLProvider("./data/").createStream("xml/planes.xml"));
    }
}

