/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.time;

import de.hardcode.time.Clock;
import de.hardcode.time.Ticker;
import de.hardcode.time.Ticking;

public class TickingThread
extends Thread
implements Ticking {
    private final Clock mClock;
    private final Ticker mTicker;
    private final long mInterval;
    private boolean mDoTick = false;

    public TickingThread(Clock clock, Ticker ticker, long interval) {
        this.mClock = clock;
        this.mTicker = ticker;
        this.mInterval = interval;
        this.start();
    }

    public Clock getClock() {
        return this.mClock;
    }

    public Ticker getTicker() {
        return this.mTicker;
    }

    public void startTicking() {
        this.mDoTick = true;
    }

    public synchronized void stopTicking() {
        this.mDoTick = false;
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            if (this.mDoTick) {
                this.getTicker().tick(this.getClock().getCurrentTime());
            }
            try {
                Thread.sleep(this.mInterval);
                TickingThread tickingThread = this;
                synchronized (tickingThread) {
                    if (!this.mDoTick) {
                        this.notify();
                    }
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

