/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.time;

import de.hardcode.time.Clock;
import de.hardcode.time.TickerListener;
import java.util.ArrayList;

public class Ticker {
    private int mTicks = 0;
    private long mCurrentTickTime;
    private float mDeltaT;
    ArrayList mListeners = new ArrayList();

    public final int getTicks() {
        return this.mTicks;
    }

    public final long getTickTime() {
        return this.mCurrentTickTime;
    }

    public float getDeltaT() {
        return this.mDeltaT;
    }

    public void reset(Clock clock) {
        this.mDeltaT = 0.0f;
        this.mCurrentTickTime = clock.getCurrentTime();
        int listenercount = this.mListeners.size();
        for (int i = listenercount - 1; i >= 0; --i) {
            ((TickerListener)this.mListeners.get(i)).reset(this);
        }
    }

    public void addClockListener(TickerListener lstr) {
        this.mListeners.add(lstr);
    }

    public void removeClockListener(TickerListener lstr) {
        this.mListeners.remove(lstr);
    }

    public void tick(long ticktime) {
        ++this.mTicks;
        this.mDeltaT = ticktime - this.mCurrentTickTime;
        this.mCurrentTickTime = ticktime;
        int listenercount = this.mListeners.size();
        for (int i = listenercount - 1; i >= 0; --i) {
            ((TickerListener)this.mListeners.get(i)).tick(this);
        }
    }
}

