/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.time;

import de.hardcode.time.Clock;
import de.hardcode.time.Ticker;

public class SmoothedTicker
extends Ticker {
    private final float[] mRemembered = new float[5];
    private int mRemIdx = 0;
    private float mAverage;
    private float mSmoothedTime;

    public SmoothedTicker(float initial) {
        for (int i = 0; i < this.mRemembered.length; ++i) {
            this.mRemembered[i] = initial;
        }
        this.mAverage = initial;
    }

    private void calcAverage() {
        this.mAverage = 0.0f;
        for (int i = 0; i < this.mRemembered.length; ++i) {
            this.mAverage += this.mRemembered[i];
        }
        this.mAverage /= (float)this.mRemembered.length;
    }

    private float filterPeaks(float dt) {
        float ratio = dt / this.mAverage;
        if ((double)ratio > 2.0 || (double)ratio < 0.5) {
            return this.mAverage;
        }
        return dt;
    }

    private void removeGlitch(long ticktime) {
        this.mSmoothedTime += this.mAverage;
        float glitch = (float)ticktime - this.mSmoothedTime;
        float correct = glitch / 100.0f;
        this.mAverage += correct;
        this.mSmoothedTime += correct;
    }

    public float getDeltaT() {
        return this.mAverage;
    }

    public void reset(Clock clock) {
        this.mSmoothedTime = clock.getCurrentTime();
        super.reset(clock);
    }

    public void tick(long ticktime) {
        float dt = ticktime - super.getTickTime();
        this.mRemembered[this.mRemIdx++] = dt;
        this.mRemIdx %= this.mRemembered.length;
        this.calcAverage();
        this.removeGlitch(ticktime);
        super.tick(ticktime);
    }
}

