/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.util;

import de.hardcode.hq.util.UpdateInProgressException;
import de.hardcode.hq.util.UpdateNotInitiatedException;

public class UpdateLock {
    private Object mOwner = null;
    private Thread mLockingThread = null;

    public final synchronized void waitForUnlock() {
        if (this.isLocked() && Thread.currentThread() == this.mLockingThread) {
            throw new UpdateInProgressException();
        }
        try {
            while (this.isLocked()) {
                this.wait();
            }
        }
        catch (InterruptedException irex) {
            return;
        }
    }

    public final synchronized void verifyIsLocked() {
        if (!this.isLocked()) {
            throw new UpdateNotInitiatedException();
        }
    }

    public final synchronized void lock(Object owner) {
        this.waitForUnlock();
        this.mLockingThread = Thread.currentThread();
        this.mOwner = owner;
    }

    public final synchronized void unlock() {
        if (!this.isLocked()) {
            throw new UpdateNotInitiatedException();
        }
        this.mOwner = null;
        this.mLockingThread = null;
        this.notify();
    }

    public final Object getOwner() {
        return this.mOwner;
    }

    public final boolean isLocked() {
        return null != this.mLockingThread;
    }
}

