/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.time.server;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.objectbus.BusLine;
import de.hardcode.hq.objectbus.BusStation;
import de.hardcode.hq.objectbus.BusTicket;
import de.hardcode.hq.objectbus.BusTicketListener;
import de.hardcode.time.Clock;

public class TimeService
implements BusTicketListener {
    private final BusStation mStation;
    private final Clock mClock;
    private final BusTicket mTicket;
    private final Identity mProtocolID;

    public TimeService(BusStation station, Identity protocolID, Clock clk) {
        this.mStation = station;
        this.mProtocolID = protocolID;
        this.mClock = clk;
        this.mTicket = new BusTicket(this.mProtocolID);
        this.mStation.add(this.mProtocolID, this);
    }

    public void close() {
        this.mStation.remove(this.mProtocolID, this);
    }

    public void arrived(BusLine l, BusTicket t) {
        this.mTicket.putLong(this.mClock.getCurrentTime());
        l.enter(this.mTicket);
        l.sendBus();
        this.mTicket.clear();
    }
}

