/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.time.client;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.objectbus.BusLine;
import de.hardcode.hq.objectbus.BusTicket;
import de.hardcode.hq.objectbus.BusTicketListener;
import de.hardcode.time.Clock;

public class TimeClient
implements BusTicketListener {
    private final BusLine mLine;
    private final Clock mClock;
    private final Identity mServiceProtocolID;
    private final BusTicket mTicket;
    private long mStartTimeStamp = -1L;
    private long mPing = 0L;

    public TimeClient(BusLine line, Identity serviceProtocolID, Clock clk) {
        this.mLine = line;
        this.mClock = clk;
        this.mServiceProtocolID = serviceProtocolID;
        this.mTicket = new BusTicket(this.mServiceProtocolID);
        this.mLine.getBusStation().add(this.mServiceProtocolID, this);
    }

    public void close() {
        this.mLine.getBusStation().remove(this.mServiceProtocolID, this);
    }

    public final synchronized long ping(boolean waitForAnswer) {
        this.mStartTimeStamp = this.mClock.getCurrentTime();
        this.mPing = Long.MAX_VALUE;
        this.mLine.enter(this.mTicket);
        this.mLine.sendBus();
        if (waitForAnswer) {
            try {
                this.wait(5000L);
            }
            catch (InterruptedException irex) {
                return Long.MAX_VALUE;
            }
        }
        return this.getPing();
    }

    public static final long ping(BusLine line, Identity serviceProtocolID, Clock clk) {
        TimeClient clt = new TimeClient(line, serviceProtocolID, clk);
        long ping = clt.ping(true);
        clt.close();
        return ping;
    }

    public final long getPing() {
        return this.mPing;
    }

    public synchronized void arrived(BusLine l, BusTicket t) {
        long timestamp = t.getLong();
        long now = this.mClock.getCurrentTime();
        this.mPing = (now - this.mStartTimeStamp) / 2L;
        t.setPosition(0);
        long servertime = t.getLong();
        this.mClock.adjust(servertime + this.mPing);
        this.notify();
    }
}

