/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.registry.server;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.objectbus.BusLine;
import de.hardcode.hq.objectbus.BusStation;
import de.hardcode.hq.objectbus.BusTicket;
import de.hardcode.hq.objectbus.BusTicketListener;
import de.hardcode.hq.registry.IdentitySet;
import de.hardcode.hq.registry.Registry;
import de.hardcode.hq.registry.protocol.RegistryMessage;
import java.util.Iterator;

public class RegistryService
implements BusTicketListener {
    private final Registry mRegistry;
    private final BusStation mStation;
    private final Identity mServiceProtocolID;
    private final Identity mServerProtocolID;
    private final RegistryMessage mMessage;

    public RegistryService(BusStation station, Identity serverProtocolID, Identity serviceProtocolID, Registry reg) {
        this.mStation = station;
        this.mServerProtocolID = serverProtocolID;
        this.mServiceProtocolID = serviceProtocolID;
        this.mRegistry = reg;
        this.mMessage = new RegistryMessage(this.mServerProtocolID);
        this.mStation.add(this.mServiceProtocolID, this);
    }

    public void close() {
        this.mStation.remove(this.mServiceProtocolID, this);
    }

    public void arrived(BusLine l, BusTicket t) {
        int numids = t.getByte();
        if (0 == numids) {
            Iterator sets = this.mRegistry.getIdentitySets();
            while (sets.hasNext()) {
                IdentitySet idset = (IdentitySet)sets.next();
                this.sendIdentitySet(idset, l);
            }
        } else {
            for (int i = 0; i < numids; ++i) {
                Identity setid = t.getID();
                IdentitySet idset = this.mRegistry.resolve(setid);
                if (null == idset) continue;
                this.sendIdentitySet(idset, l);
            }
        }
    }

    private final void sendIdentitySet(IdentitySet s, BusLine l) {
        Iterator subsets = s.getSubsets();
        while (subsets.hasNext()) {
            IdentitySet subset = (IdentitySet)subsets.next();
            this.mMessage.addedSubset(s, subset);
            l.enter(this.mMessage.getTicket());
        }
        Iterator members = s.getMembers();
        while (members.hasNext()) {
            Identity member = (Identity)members.next();
            this.mMessage.addedMember(s, member);
            l.enter(this.mMessage.getTicket());
        }
    }
}

