/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.registry.protocol;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.objectbus.BusTicket;
import de.hardcode.hq.registry.IdentitySet;

public class RegistryMessage {
    private final BusTicket mTicket;
    private final Identity mProtocolID;

    public RegistryMessage(Identity protocolID) {
        this.mProtocolID = protocolID;
        this.mTicket = new BusTicket(this.mProtocolID);
    }

    public BusTicket getTicket() {
        return this.mTicket;
    }

    public void eliminated(IdentitySet which) {
        this.mTicket.clear();
        this.mTicket.putByte((byte)1);
        this.mTicket.putID(which.getIdentity());
    }

    public void addedMember(IdentitySet where, Identity what) {
        this.mTicket.clear();
        this.mTicket.putByte((byte)2);
        this.mTicket.putID(where.getIdentity());
        this.mTicket.putID(what);
    }

    public void addedSubset(IdentitySet where, IdentitySet what) {
        this.mTicket.clear();
        this.mTicket.putByte((byte)4);
        this.mTicket.putID(where.getIdentity());
        this.mTicket.putID(what.getIdentity());
    }

    public void removedMember(IdentitySet where, Identity what) {
        this.mTicket.clear();
        this.mTicket.putByte((byte)3);
        this.mTicket.putID(where.getIdentity());
        this.mTicket.putID(what);
    }

    public void removedSubset(IdentitySet where, IdentitySet what) {
        this.mTicket.clear();
        this.mTicket.putByte((byte)5);
        this.mTicket.putID(where.getIdentity());
        this.mTicket.putID(what.getIdentity());
    }
}

