/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.registry.client;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.objectbus.BusLine;
import de.hardcode.hq.objectbus.BusStation;
import de.hardcode.hq.objectbus.BusTicket;
import de.hardcode.hq.objectbus.BusTicketListener;
import de.hardcode.hq.registry.IdentitySet;
import de.hardcode.hq.registry.Registry;
import de.hardcode.hq.registry.RegistryListener;
import de.hardcode.hq.registry.protocol.RegistryMessage;

public class RegistryClient
implements BusTicketListener,
RegistryListener {
    private final Registry mRegistry;
    private final BusStation mStation;
    private final Identity mProtocolID;
    private final Identity mServiceProtocolID;
    private final RegistryMessage mMessage;

    public RegistryClient(BusStation station, Identity serverProtocolID, Identity serviceProtocolID, Registry registry) {
        this.mStation = station;
        this.mProtocolID = serverProtocolID;
        this.mServiceProtocolID = serviceProtocolID;
        this.mRegistry = registry;
        this.mMessage = new RegistryMessage(this.mProtocolID);
        this.mRegistry.addListener(this);
        this.mStation.add(this.mProtocolID, this);
    }

    public void close() {
        this.mStation.remove(this.mProtocolID, this);
        this.mRegistry.removeListener(this);
    }

    public void download() {
        BusTicket t = new BusTicket(this.mServiceProtocolID);
        t.putByte((byte)0);
        this.mStation.broadcast(t, null);
    }

    public void arrived(BusLine l, BusTicket t) {
        t.setPosition(0);
        byte action = t.getByte();
        Identity whereid = t.getID();
        IdentitySet where = this.guaranteedResolve(whereid);
        if (action == 1) {
            where.eliminate(this);
        } else {
            Identity whatid = t.getID();
            if (action == 4) {
                IdentitySet what = this.guaranteedResolve(whatid);
                where.addSubset(what, this);
            } else if (action == 5) {
                IdentitySet what = this.guaranteedResolve(whatid);
                where.removeSubset(what, this);
            } else if (action == 2) {
                where.add(whatid, this);
            } else {
                where.remove(whatid, this);
            }
        }
    }

    private final IdentitySet guaranteedResolve(Identity id) {
        IdentitySet s = this.mRegistry.resolve(id);
        if (null == s) {
            s = this.mRegistry.createSet(id);
        }
        return s;
    }

    public void eliminated(IdentitySet which, Object initiator) {
        if (initiator != this) {
            this.mMessage.eliminated(which);
            this.mStation.broadcast(this.mMessage.getTicket(), null);
        }
    }

    public void addedMember(IdentitySet where, Identity what, Object initiator) {
        if (initiator != this) {
            this.mMessage.addedMember(where, what);
            this.mStation.broadcast(this.mMessage.getTicket(), null);
        }
    }

    public void addedSubset(IdentitySet where, IdentitySet what, Object initiator) {
        if (initiator != this) {
            this.mMessage.addedSubset(where, what);
            this.mStation.broadcast(this.mMessage.getTicket(), null);
        }
    }

    public void removedMember(IdentitySet where, Identity what, Object initiator) {
        if (initiator != this) {
            this.mMessage.removedMember(where, what);
            this.mStation.broadcast(this.mMessage.getTicket(), null);
        }
    }

    public void removedSubset(IdentitySet where, IdentitySet what, Object initiator) {
        if (initiator != this) {
            this.mMessage.removedSubset(where, what);
            this.mStation.broadcast(this.mMessage.getTicket(), null);
        }
    }
}

