/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.registry;

import de.hardcode.hq.identity.IdentifyableRegistry;
import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.registry.IdentitySet;
import de.hardcode.hq.registry.RegistryListener;
import java.util.ArrayList;
import java.util.Iterator;

public class Registry {
    private final IdentifyableRegistry mIdentRegistry = new IdentifyableRegistry();
    private final ArrayList mListeners = new ArrayList();

    public final IdentitySet createSet(Identity id) {
        IdentitySet idset = this.resolve(id);
        if (null != idset) {
            return idset;
        }
        idset = new IdentitySet(this, id);
        this.mIdentRegistry.register(idset);
        return idset;
    }

    public final Iterator getIdentitySets() {
        return this.mIdentRegistry.getIdentifyables();
    }

    public void eliminate(IdentitySet idset, Object initiator) {
        this.mIdentRegistry.unregister(idset);
        Iterator ids = this.mIdentRegistry.getIdentifyables();
        while (ids.hasNext()) {
            IdentitySet s = (IdentitySet)ids.next();
            s.remove(idset.getIdentity(), null);
            s.removeSubset(idset, null);
        }
        this.notifyEliminated(idset, initiator);
    }

    public final IdentitySet resolve(Identity id) {
        return (IdentitySet)this.mIdentRegistry.resolve(id);
    }

    public final void addListener(RegistryListener l) {
        this.mListeners.add(l);
    }

    public final void removeListener(RegistryListener l) {
        this.mListeners.remove(l);
    }

    final void notifyEliminated(IdentitySet which, Object initiator) {
        int n = this.mListeners.size();
        for (int i = n - 1; i >= 0; --i) {
            RegistryListener l = (RegistryListener)this.mListeners.get(i);
            l.eliminated(which, initiator);
        }
    }

    final void notifyMemberAdded(IdentitySet to, Identity id, Object initiator) {
        int n = this.mListeners.size();
        for (int i = n - 1; i >= 0; --i) {
            RegistryListener l = (RegistryListener)this.mListeners.get(i);
            l.addedMember(to, id, initiator);
        }
    }

    final void notifyMemberRemoved(IdentitySet from, Identity id, Object initiator) {
        int n = this.mListeners.size();
        for (int i = n - 1; i >= 0; --i) {
            RegistryListener l = (RegistryListener)this.mListeners.get(i);
            l.removedMember(from, id, initiator);
        }
    }

    final void notifySubsetAdded(IdentitySet to, IdentitySet idset, Object initiator) {
        int n = this.mListeners.size();
        for (int i = n - 1; i >= 0; --i) {
            RegistryListener l = (RegistryListener)this.mListeners.get(i);
            l.addedSubset(to, idset, initiator);
        }
    }

    final void notifySubsetRemoved(IdentitySet from, IdentitySet idset, Object initiator) {
        int n = this.mListeners.size();
        for (int i = n - 1; i >= 0; --i) {
            RegistryListener l = (RegistryListener)this.mListeners.get(i);
            l.removedSubset(from, idset, initiator);
        }
    }
}

