/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.registry;

import de.hardcode.hq.identity.Identifyable;
import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.registry.Registry;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class IdentitySet
implements Identifyable {
    private final Registry mRegistry;
    public static final int SEARCH_FLAT = 0;
    public static final int SEARCH_DEEP = Integer.MAX_VALUE;
    private Identity mIdentity;
    private final HashSet mMembers = new HashSet();
    private final HashSet mSubsets = new HashSet();

    IdentitySet(Registry reg, Identity id) {
        this.mRegistry = reg;
        this.mIdentity = id;
    }

    public void eliminate(Object initiator) {
        this.mRegistry.eliminate(this, initiator);
    }

    public Identity getIdentity() {
        return this.mIdentity;
    }

    public final void add(Identity id, Object initiator) {
        if (this.mMembers.add(id)) {
            this.mRegistry.notifyMemberAdded(this, id, initiator);
        }
    }

    public final void remove(Identity id, Object initiator) {
        if (this.mMembers.remove(id)) {
            this.mRegistry.notifyMemberRemoved(this, id, initiator);
        }
    }

    public final Iterator getMembers() {
        return this.mMembers.iterator();
    }

    public final int getMemberCount() {
        return this.mMembers.size();
    }

    public final void addSubset(IdentitySet idset, Object initiator) {
        if (this.mSubsets.add(idset)) {
            this.mRegistry.notifySubsetAdded(this, idset, initiator);
        }
    }

    public final void removeSubset(IdentitySet idset, Object initiator) {
        if (this.mSubsets.remove(idset)) {
            this.mRegistry.notifySubsetRemoved(this, idset, initiator);
        }
    }

    public final Iterator getSubsets() {
        return this.mSubsets.iterator();
    }

    public final int getSubsetCount() {
        return this.mSubsets.size();
    }

    public final boolean hasMember(Identity id, int searchdepth) {
        if (this.mMembers.contains(id)) {
            return true;
        }
        if (searchdepth > 0) {
            --searchdepth;
            Iterator it = this.mSubsets.iterator();
            while (it.hasNext()) {
                IdentitySet s = (IdentitySet)it.next();
                if (!s.hasMember(id, searchdepth)) continue;
                return true;
            }
        }
        return false;
    }

    public static final Set getMemberShips(Identity id, IdentitySet s) {
        HashSet result = new HashSet();
        IdentitySet.collectMemberShips(id, s, result);
        return result;
    }

    private static final void collectMemberShips(Identity id, IdentitySet s, Set result) {
        if (s.hasMember(id, 0)) {
            result.add(s);
        }
        Iterator it = s.getSubsets();
        while (it.hasNext()) {
            IdentitySet sub = (IdentitySet)it.next();
            IdentitySet.collectMemberShips(id, sub, result);
        }
    }

    public Set getMemberShips(Identity id) {
        return IdentitySet.getMemberShips(id, this);
    }

    public final boolean hasSubset(IdentitySet idset, int searchdepth) {
        if (this.mSubsets.contains(idset)) {
            return true;
        }
        if (searchdepth > 0) {
            --searchdepth;
            Iterator it = this.mSubsets.iterator();
            while (it.hasNext()) {
                IdentitySet s = (IdentitySet)it.next();
                if (!s.hasSubset(idset, searchdepth)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isSubsetOf(IdentitySet idset) {
        return idset.hasSubset(this, Integer.MAX_VALUE);
    }
}

