/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.property.test;

import de.hardcode.hq.identity.NamedIdentity;
import de.hardcode.hq.objectbus.NetLine;
import de.hardcode.hq.objectbus.NetStation;
import de.hardcode.hq.property.IntegerValue;
import de.hardcode.hq.property.Properties;
import de.hardcode.hq.property.PropertyListener;
import de.hardcode.hq.property.PropertySet;
import de.hardcode.hq.property.StringValue;
import de.hardcode.hq.property.client.PropertyClient;
import de.hardcode.hq.property.test.ID;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Client {
    public Client() {
        NetStation station = new NetStation();
        NetLine line = null;
        try {
            line = station.createLine(InetAddress.getLocalHost(), 13664);
        }
        catch (UnknownHostException uhex) {
            // empty catch block
        }
        station.startReceive();
        Properties properties = new Properties();
        PropertyClient clt = new PropertyClient(station, ID.PROPERTY_ID, ID.PROPERTY_SERVICE_ID, properties);
        PropertySet ps = new PropertySet(properties, new NamedIdentity("propset1"));
        StringValue svalue1 = new StringValue(ps, new NamedIdentity("stringvalue1"));
        StringValue svalue2 = new StringValue(ps, new NamedIdentity("other value"));
        IntegerValue ivalue1 = new IntegerValue(ps, new NamedIdentity("int1"));
        IntegerValue ivalue2 = new IntegerValue(ps, new NamedIdentity("int2"));
        ps.startUpdate(this);
        svalue1.set("Hello World!");
        svalue2.set("Hello World!");
        ps.finishUpdate();
        for (int i = 0; i < 10000; ++i) {
            ps.startUpdate(this);
            svalue1.set(Integer.toString(i));
            svalue2.set(Integer.toString(100000 - i));
            ivalue1.set(i);
            ivalue2.add(1);
            ps.finishUpdate();
            station.flush();
        }
        station.flush();
        line.close();
        station.close();
    }

    public static void main(String[] args) {
        new Client();
        System.out.println("Client finished!");
    }

    class reporter
    implements PropertyListener {
        reporter() {
        }

        public void changed(PropertySet which, Object initiator) {
            System.out.println("Changed: " + which + " " + initiator);
        }

        public void created(PropertySet which, Object initiator) {
            System.out.println("Created: " + which + " " + initiator);
        }

        public void eliminated(PropertySet which, Object initiator) {
            System.out.println("Eliminated: " + which + " " + initiator);
        }
    }
}

