/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.property.server;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.objectbus.BusLine;
import de.hardcode.hq.objectbus.BusStation;
import de.hardcode.hq.objectbus.BusTicket;
import de.hardcode.hq.objectbus.BusTicketListener;
import de.hardcode.hq.property.Properties;
import de.hardcode.hq.property.PropertySet;
import de.hardcode.hq.property.protocol.PropertyMessage;
import java.util.Iterator;

public class PropertyService
implements BusTicketListener {
    private final Properties mProperties;
    private final BusStation mStation;
    private final Identity mServiceProtocolID;
    private final Identity mServerProtocolID;
    private final PropertyMessage mMessage;

    public PropertyService(BusStation station, Identity serverProtocolID, Identity serviceProtocolID, Properties props) {
        this.mStation = station;
        this.mServerProtocolID = serverProtocolID;
        this.mServiceProtocolID = serviceProtocolID;
        this.mProperties = props;
        this.mMessage = new PropertyMessage(this.mServerProtocolID);
        this.mStation.add(this.mServiceProtocolID, this);
    }

    public void close() {
        this.mStation.remove(this.mServiceProtocolID, this);
    }

    public void arrived(BusLine l, BusTicket t) {
        int numids = t.getByte();
        if (0 == numids) {
            Iterator sets = this.mProperties.getPropertySets();
            while (sets.hasNext()) {
                PropertySet propset = (PropertySet)sets.next();
                this.sendPropertySet(propset, l);
            }
        } else {
            for (int i = 0; i < numids; ++i) {
                Identity setid = t.getID();
                PropertySet propset = this.mProperties.resolve(setid);
                if (null == propset) continue;
                this.sendPropertySet(propset, l);
            }
        }
    }

    private final void sendPropertySet(PropertySet s, BusLine l) {
        this.mMessage.send(s);
        l.enter(this.mMessage.getTicket());
    }
}

