/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.property.protocol;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.objectbus.BusTicket;
import de.hardcode.hq.property.BooleanValue;
import de.hardcode.hq.property.IntegerValue;
import de.hardcode.hq.property.LongValue;
import de.hardcode.hq.property.PropertySet;
import de.hardcode.hq.property.StringValue;
import de.hardcode.hq.property.Value;
import de.hardcode.hq.property.changes.BooleanChange;
import de.hardcode.hq.property.changes.Change;
import de.hardcode.hq.property.changes.Changes;
import de.hardcode.hq.property.changes.IntegerChange;
import de.hardcode.hq.property.changes.IntegerIncrement;
import de.hardcode.hq.property.changes.LongChange;
import de.hardcode.hq.property.changes.LongIncrement;
import de.hardcode.hq.property.changes.StringChange;
import java.util.Iterator;

public class PropertyMessage {
    private final BusTicket mTicket;
    private final Identity mProtocolID;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PropertyMessage(Identity protocolID) {
        this.mProtocolID = protocolID;
        this.mTicket = new BusTicket(this.mProtocolID);
    }

    public BusTicket getTicket() {
        return this.mTicket;
    }

    public void eliminated(PropertySet which) {
        this.mTicket.clear();
        this.mTicket.putID(which.getIdentity());
        this.mTicket.putByte((byte)1);
    }

    public void changed(PropertySet which) {
        Changes what = which.getChanges();
        this.mTicket.clear();
        this.mTicket.putID(which.getIdentity());
        this.mTicket.putByte((byte)2);
        int changecount = what.getChangeCount();
        this.mTicket.putShort((short)changecount);
        for (int i = 0; i < changecount; ++i) {
            Change chg = what.getChange(i);
            if (chg instanceof StringChange) {
                this.encodeStringChanged(chg.getValue().getIdentity(), ((StringChange)chg).getNewString());
                continue;
            }
            if (chg instanceof IntegerChange) {
                this.encodeIntChanged(chg.getValue().getIdentity(), ((IntegerChange)chg).getNewValue());
                continue;
            }
            if (chg instanceof IntegerIncrement) {
                this.encodeDescription(chg.getValue().getIdentity(), (byte)4);
                this.mTicket.putInt(((IntegerIncrement)chg).getIncrement());
                continue;
            }
            if (chg instanceof LongChange) {
                this.encodeLongChanged(chg.getValue().getIdentity(), ((LongChange)chg).getNewValue());
                continue;
            }
            if (chg instanceof LongIncrement) {
                this.encodeDescription(chg.getValue().getIdentity(), (byte)6);
                this.mTicket.putLong(((LongIncrement)chg).getIncrement());
                continue;
            }
            if (chg instanceof BooleanChange) {
                this.encodeBooleanChanged(chg.getValue().getIdentity(), ((BooleanChange)chg).getNewValue());
                continue;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"unknown type of change!");
            }
        }
    }

    public void send(PropertySet s) {
        this.mTicket.clear();
        this.mTicket.putID(s.getIdentity());
        this.mTicket.putByte((byte)2);
        this.mTicket.putShort((short)s.getValueCount());
        Iterator values = s.getValues();
        while (values.hasNext()) {
            Value val = (Value)values.next();
            if (val instanceof StringValue) {
                this.encodeStringChanged(val.getIdentity(), ((StringValue)val).get());
                continue;
            }
            if (val instanceof IntegerValue) {
                this.encodeIntChanged(val.getIdentity(), ((IntegerValue)val).get());
                continue;
            }
            if (val instanceof LongValue) {
                this.encodeLongChanged(val.getIdentity(), ((LongValue)val).get());
                continue;
            }
            if (val instanceof BooleanValue) {
                this.encodeBooleanChanged(val.getIdentity(), ((BooleanValue)val).get());
                continue;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"unknown type of value!");
            }
        }
    }

    private final void encodeDescription(Identity id, byte code) {
        this.mTicket.putByte(code);
        this.mTicket.putID(id);
    }

    private final void encodeStringChanged(Identity id, String val) {
        this.encodeDescription(id, (byte)2);
        this.mTicket.putString(val);
    }

    private final void encodeIntChanged(Identity id, int val) {
        this.encodeDescription(id, (byte)3);
        this.mTicket.putInt(val);
    }

    private final void encodeLongChanged(Identity id, long val) {
        this.encodeDescription(id, (byte)5);
        this.mTicket.putLong(val);
    }

    private final void encodeBooleanChanged(Identity id, boolean val) {
        this.encodeDescription(id, (byte)7);
        this.mTicket.putByte(val ? (byte)1 : 0);
    }

    static {
        $assertionsDisabled = !PropertyMessage.class.desiredAssertionStatus();
    }
}

