/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.property.client;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.objectbus.BusLine;
import de.hardcode.hq.objectbus.BusStation;
import de.hardcode.hq.objectbus.BusTicket;
import de.hardcode.hq.objectbus.BusTicketListener;
import de.hardcode.hq.property.BooleanValue;
import de.hardcode.hq.property.IntegerValue;
import de.hardcode.hq.property.LongValue;
import de.hardcode.hq.property.Properties;
import de.hardcode.hq.property.PropertyListener;
import de.hardcode.hq.property.PropertySet;
import de.hardcode.hq.property.StringValue;
import de.hardcode.hq.property.Value;
import de.hardcode.hq.property.client.Log;
import de.hardcode.hq.property.protocol.PropertyMessage;

public class PropertyClient
implements BusTicketListener,
PropertyListener {
    private final BusStation mStation;
    private final Identity mProtocolID;
    private final Identity mServiceProtocolID;
    private final Properties mProperties;
    private final PropertyMessage mMessage;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PropertyClient(BusStation station, Identity serverProtocolID, Identity serviceProtocolID, Properties properties) {
        this.mStation = station;
        this.mProtocolID = serverProtocolID;
        this.mServiceProtocolID = serviceProtocolID;
        this.mProperties = properties;
        this.mMessage = new PropertyMessage(this.mProtocolID);
        this.mProperties.addListener(this);
        this.mStation.add(this.mProtocolID, this);
    }

    public void close() {
        this.mStation.remove(this.mProtocolID, this);
        this.mProperties.removeListener(this);
    }

    public void download() {
        BusTicket t = new BusTicket(this.mServiceProtocolID);
        t.putByte((byte)0);
        this.mStation.broadcast(t, null);
    }

    public void arrived(BusLine l, BusTicket t) {
        t.setPosition(0);
        Identity whereid = t.getID();
        PropertySet where = this.guaranteedResolve(whereid);
        byte type = t.getByte();
        if (type == 1) {
            where.eliminate(this);
        } else if (type == 2) {
            where.startUpdate(this);
            int numchanges = t.getShort();
            Log.logger.fine("Received " + numchanges + " changes.");
            for (int i = 0; i < numchanges; ++i) {
                LongValue val;
                Value val2;
                Identity valueid;
                byte changetype = t.getByte();
                if (changetype == 2) {
                    valueid = t.getID();
                    String str = t.getString();
                    val2 = (StringValue)this.guaranteedGetValue(where, valueid, class$de$hardcode$hq$property$StringValue == null ? PropertyClient.class$("de.hardcode.hq.property.StringValue") : class$de$hardcode$hq$property$StringValue);
                    ((StringValue)val2).set(str);
                    continue;
                }
                if (changetype == 3) {
                    valueid = t.getID();
                    int newval = t.getInt();
                    val2 = (IntegerValue)this.guaranteedGetValue(where, valueid, class$de$hardcode$hq$property$IntegerValue == null ? PropertyClient.class$("de.hardcode.hq.property.IntegerValue") : class$de$hardcode$hq$property$IntegerValue);
                    ((IntegerValue)val2).set(newval);
                    continue;
                }
                if (changetype == 4) {
                    valueid = t.getID();
                    int inc = t.getInt();
                    val2 = (IntegerValue)this.guaranteedGetValue(where, valueid, class$de$hardcode$hq$property$IntegerValue == null ? PropertyClient.class$("de.hardcode.hq.property.IntegerValue") : class$de$hardcode$hq$property$IntegerValue);
                    ((IntegerValue)val2).add(inc);
                    continue;
                }
                if (changetype == 5) {
                    valueid = t.getID();
                    long newval = t.getLong();
                    val = (LongValue)this.guaranteedGetValue(where, valueid, class$de$hardcode$hq$property$LongValue == null ? PropertyClient.class$("de.hardcode.hq.property.LongValue") : class$de$hardcode$hq$property$LongValue);
                    val.set(newval);
                    continue;
                }
                if (changetype == 6) {
                    valueid = t.getID();
                    long inc = t.getLong();
                    val = (LongValue)this.guaranteedGetValue(where, valueid, class$de$hardcode$hq$property$LongValue == null ? PropertyClient.class$("de.hardcode.hq.property.LongValue") : class$de$hardcode$hq$property$LongValue);
                    val.add(inc);
                    continue;
                }
                if (changetype != 7) continue;
                valueid = t.getID();
                byte flag = t.getByte();
                val2 = (BooleanValue)this.guaranteedGetValue(where, valueid, class$de$hardcode$hq$property$BooleanValue == null ? PropertyClient.class$("de.hardcode.hq.property.BooleanValue") : class$de$hardcode$hq$property$BooleanValue);
                ((BooleanValue)val2).set(flag != 0);
            }
            where.finishUpdate();
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Unexpected message type");
        }
    }

    private final PropertySet guaranteedResolve(Identity id) {
        PropertySet s = this.mProperties.resolve(id);
        if (null == s) {
            s = this.mProperties.createPropertySet(id, this);
        }
        return s;
    }

    private final Value guaranteedGetValue(PropertySet set, Identity valueid, Class valueclass) {
        Value result = set.getValue(valueid);
        if (null != result) {
            if (!$assertionsDisabled && !result.getClass().equals(valueclass)) {
                throw new AssertionError((Object)"Existing value does not match type of incoming data");
            }
            return result;
        }
        if (valueclass.equals(StringValue.class)) {
            return new StringValue(set, valueid);
        }
        if (valueclass.equals(IntegerValue.class)) {
            return new IntegerValue(set, valueid);
        }
        if (valueclass.equals(LongValue.class)) {
            return new LongValue(set, valueid);
        }
        if (valueclass.equals(BooleanValue.class)) {
            return new BooleanValue(set, valueid);
        }
        return null;
    }

    public void eliminated(PropertySet which, Object initiator) {
        if (initiator != this) {
            this.mMessage.eliminated(which);
            this.mStation.broadcast(this.mMessage.getTicket(), null);
        }
    }

    public void changed(PropertySet which, Object initiator) {
        if (initiator != this) {
            this.mMessage.changed(which);
            this.mStation.broadcast(this.mMessage.getTicket(), null);
        }
    }

    public void created(PropertySet which, Object initiator) {
    }

    static {
        $assertionsDisabled = !PropertyClient.class.desiredAssertionStatus();
    }
}

