/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.property;

import de.hardcode.hq.identity.Identifyable;
import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.property.Properties;
import de.hardcode.hq.property.Value;
import de.hardcode.hq.property.changes.Changes;
import de.hardcode.hq.util.UpdateLock;
import java.util.HashMap;
import java.util.Iterator;

public class PropertySet
implements Identifyable {
    private final Properties mProperties;
    private final Identity mIdentity;
    private final HashMap mValues = new HashMap();
    private final UpdateLock mLock = new UpdateLock();
    private final Changes mWhatChanged = new Changes();
    static final /* synthetic */ boolean $assertionsDisabled;

    public PropertySet(Properties properties, Identity id) {
        this.mProperties = properties;
        this.mIdentity = id;
    }

    public Identity getIdentity() {
        return this.mIdentity;
    }

    public final Iterator getValues() {
        return this.mValues.values().iterator();
    }

    public final int getValueCount() {
        return this.mValues.size();
    }

    public synchronized void eliminate(Object initiator) {
        this.mLock.waitForUnlock();
        this.mProperties.eliminate(this, initiator);
    }

    public Value getValue(Identity id) {
        return (Value)this.mValues.get(id);
    }

    public synchronized void startUpdate(Object initiator) {
        this.mLock.lock(initiator);
    }

    public Object getUpdateInitiator() {
        return this.mLock.getOwner();
    }

    public synchronized void finishUpdate() {
        if (this.mWhatChanged.getChangeCount() > 0) {
            this.mProperties.notifyChanged(this, this.mLock.getOwner());
        }
        this.mWhatChanged.clear();
        this.mLock.unlock();
    }

    public final Changes getChanges() {
        this.mLock.verifyIsLocked();
        return this.mWhatChanged;
    }

    void add(Value v) {
        Value o = this.mValues.put(v.getIdentity(), v);
        if (!$assertionsDisabled && null != o) {
            throw new AssertionError();
        }
    }

    void remove(Value v) {
        Value o = (Value)this.mValues.remove(v.getIdentity());
        if (!$assertionsDisabled && o != v) {
            throw new AssertionError();
        }
    }

    static {
        $assertionsDisabled = !PropertySet.class.desiredAssertionStatus();
    }
}

