/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.property;

import de.hardcode.hq.identity.IdentifyableRegistry;
import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.property.PropertyListener;
import de.hardcode.hq.property.PropertySet;
import java.util.ArrayList;
import java.util.Iterator;

public class Properties {
    private final IdentifyableRegistry mIdentRegistry = new IdentifyableRegistry();
    private final ArrayList mListeners = new ArrayList();

    public PropertySet createPropertySet(Identity id, Object initiator) {
        PropertySet set = this.resolve(id);
        if (null != set) {
            return set;
        }
        set = new PropertySet(this, id);
        this.mIdentRegistry.register(set);
        this.notifyCreated(set, initiator);
        return set;
    }

    public final Iterator getPropertySets() {
        return this.mIdentRegistry.getIdentifyables();
    }

    public void eliminate(PropertySet set, Object initiator) {
        this.mIdentRegistry.unregister(set);
        this.notifyEliminated(set, initiator);
    }

    public final PropertySet resolve(Identity id) {
        return (PropertySet)this.mIdentRegistry.resolve(id);
    }

    public final void addListener(PropertyListener l) {
        this.mListeners.add(l);
    }

    public final void removeListener(PropertyListener l) {
        this.mListeners.remove(l);
    }

    final void notifyCreated(PropertySet which, Object initiator) {
        int n = this.mListeners.size();
        for (int i = n - 1; i >= 0; --i) {
            PropertyListener l = (PropertyListener)this.mListeners.get(i);
            l.created(which, initiator);
        }
    }

    final void notifyEliminated(PropertySet which, Object initiator) {
        int n = this.mListeners.size();
        for (int i = n - 1; i >= 0; --i) {
            PropertyListener l = (PropertyListener)this.mListeners.get(i);
            l.eliminated(which, initiator);
        }
    }

    final void notifyChanged(PropertySet which, Object initiator) {
        int n = this.mListeners.size();
        for (int i = n - 1; i >= 0; --i) {
            PropertyListener l = (PropertyListener)this.mListeners.get(i);
            l.changed(which, initiator);
        }
    }
}

