/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.objectbus;

import de.hardcode.hq.objectbus.Log;
import de.hardcode.hq.objectbus.NetStation;

class NetStationReceiver {
    private final NetStation mStation;
    private boolean mIsReceiving = false;

    public NetStationReceiver(NetStation station) {
        this.mStation = station;
    }

    public final NetStation getStation() {
        return this.mStation;
    }

    public final boolean isReceiving() {
        return this.mIsReceiving;
    }

    public void close() {
        if (!this.isReceiving()) {
            return;
        }
        this.mIsReceiving = false;
    }

    public final void receive(boolean asynchronous) {
        this.mIsReceiving = true;
        ReceiverRunnable r = new ReceiverRunnable();
        if (asynchronous) {
            new Thread(r).start();
        } else {
            r.run();
        }
    }

    private final class ReceiverRunnable
    implements Runnable {
        private ReceiverRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (NetStationReceiver.this.mIsReceiving) {
                NetStationReceiver.this.getStation().handleIncoming(true);
            }
            Log.logger.finer("Synchronizing with the BusStation.");
            NetStation netStation = NetStationReceiver.this.getStation();
            synchronized (netStation) {
                Log.logger.finer("Notifying BusStation.");
                NetStationReceiver.this.getStation().notify();
            }
        }
    }
}

