/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.objectbus;

import de.hardcode.hq.objectbus.BusTicket;
import de.hardcode.hq.objectbus.LocalStation;
import de.hardcode.hq.objectbus.Log;
import de.hardcode.hq.objectbus.NetLine;
import de.hardcode.hq.objectbus.NetStationReceiver;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;

public class NetStation
extends LocalStation {
    private final ByteBuffer mBuffer;
    private Selector mSelector = null;
    private boolean mIsOperational = false;
    private final NetStationReceiver mReceiver = new NetStationReceiver(this);
    public static final int DEFAULT_BUFFER_SIZE = 102400;
    private ServerSocketChannel mServerChannel = null;

    public NetStation() {
        this(0);
    }

    public NetStation(int port) {
        try {
            this.mSelector = Selector.open();
            if (port > 0) {
                this.configureConnectable(port);
            }
            this.mIsOperational = true;
        }
        catch (IOException ioex) {
            Log.logger.throwing("de.hardcode.hq.objectbus.NetStation", "<init>", ioex);
        }
        this.mBuffer = this.isOperational() ? ByteBuffer.allocate(102400) : null;
    }

    public void startReceive() {
        if (this.isOperational()) {
            this.mReceiver.receive(true);
        }
    }

    public synchronized void close() {
        super.close();
        try {
            Log.logger.fine("Closing all receiver and selector.");
            this.mReceiver.close();
            Log.logger.finer("Waking up selector to unblock the receiver.");
            this.mSelector.wakeup();
            try {
                Log.logger.finer("Wait for a notification.");
                this.wait(500L);
                Log.logger.finer("Notification arrived.");
            }
            catch (InterruptedException irex) {
                // empty catch block
            }
            Log.logger.finer("Closing selector.");
            this.mSelector.close();
            if (null != this.mServerChannel) {
                Log.logger.finer("Closing server channel.");
                this.mServerChannel.close();
            }
        }
        catch (IOException ioex) {
            Log.logger.throwing("de.hardcode.hq.objectbus.NetStation", "close()", ioex);
        }
        this.mIsOperational = false;
    }

    public void finalize() {
        this.close();
    }

    public final boolean isOperational() {
        return this.mIsOperational;
    }

    public final NetLine createLine(InetAddress dest, int port) {
        if (!this.isOperational()) {
            return null;
        }
        try {
            InetSocketAddress isa = new InetSocketAddress(dest, port);
            SocketChannel channel = SocketChannel.open(isa);
            return this.establishNetLine(channel);
        }
        catch (IOException ioex) {
            return null;
        }
    }

    final void configureConnectable(int port) throws IOException {
        Log.logger.fine("Configure NetStation to be connectable on port " + port);
        this.mServerChannel = ServerSocketChannel.open();
        this.mServerChannel.configureBlocking(false);
        InetSocketAddress isa = new InetSocketAddress(port);
        this.mServerChannel.socket().bind(isa);
        this.mServerChannel.register(this.mSelector, 16);
    }

    void handleIncoming(boolean blocking) {
        try {
            if (this.mSelector.isOpen() && (blocking ? this.mSelector.select() : this.mSelector.selectNow()) > 0) {
                this.notifyStartHandleIncoming();
                this.dispatchKeys();
                this.notifyFinishedHandleIncoming();
            }
        }
        catch (ClosedSelectorException csex) {
            Log.logger.fine("Selector has been closed! Closing.");
            this.close();
        }
        catch (IOException ioex) {
            Log.logger.fine("Received IO exception! Closing.");
            this.close();
        }
        catch (Exception ex) {
            Log.logger.throwing(this.getClass().toString(), "handleIncoming", ex);
            this.close();
        }
    }

    private final void dispatchKeys() {
        Set<SelectionKey> readyKeys = this.mSelector.selectedKeys();
        if (readyKeys == null) {
            return;
        }
        Iterator<SelectionKey> i = readyKeys.iterator();
        while (i.hasNext()) {
            SelectionKey key = i.next();
            i.remove();
            if (key.isValid() && key.isAcceptable()) {
                this.establishIncomingLine(key);
                continue;
            }
            if (!key.isValid() || !key.isReadable()) continue;
            this.evaluateMessage(key);
        }
    }

    private final void establishIncomingLine(SelectionKey key) {
        try {
            ServerSocketChannel nextReady = (ServerSocketChannel)key.channel();
            SocketChannel channel = nextReady.accept();
            this.establishNetLine(channel);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private final NetLine establishNetLine(SocketChannel ch) throws IOException {
        ch.socket().setTcpNoDelay(true);
        ch.configureBlocking(false);
        SelectionKey readKey = ch.register(this.mSelector, 1);
        NetLine l = new NetLine(this, ch);
        readKey.attach(l);
        return l;
    }

    private final void evaluateMessage(SelectionKey key) {
        NetLine line = (NetLine)key.attachment();
        SocketChannel socketchannel = (SocketChannel)key.channel();
        this.mBuffer.clear();
        while (!this.readAndParse(line, socketchannel)) {
        }
    }

    private final boolean readAndParse(NetLine line, SocketChannel socketchannel) {
        try {
            int nbytes = socketchannel.read(this.mBuffer);
            if (-1 == nbytes) {
                Log.logger.fine("Channel has EOF, closing line.");
                line.close();
                return true;
            }
        }
        catch (AsynchronousCloseException acex) {
            Log.logger.fine("Channel has been closed asynchronously, closing line.");
            this.close();
            return true;
        }
        catch (ClosedChannelException ccex) {
            Log.logger.fine("Channel has been closed, closing line.");
            this.close();
            return true;
        }
        catch (IOException ioex) {
            Log.logger.fine("Problem reading from channel, closing line.");
            line.close();
            return true;
        }
        this.mBuffer.flip();
        while (this.mBuffer.position() < this.mBuffer.limit()) {
            if (this.mBuffer.remaining() < 2) {
                this.prepareBufferForNextRead();
                return false;
            }
            short ticketlen = this.mBuffer.getShort();
            if (ticketlen > this.mBuffer.remaining()) {
                this.mBuffer.position(this.mBuffer.position() - 2);
                this.prepareBufferForNextRead();
                return false;
            }
            ByteBuffer ticketbuffer = this.mBuffer.slice();
            ticketbuffer.limit(ticketlen);
            this.mBuffer.position(this.mBuffer.position() + ticketlen);
            BusTicket ticket = new BusTicket(ticketbuffer);
            this.notifyIncomingBus(line, ticket);
        }
        return true;
    }

    private final void prepareBufferForNextRead() {
        ByteBuffer rest = this.mBuffer.slice();
        this.mBuffer.clear();
        this.mBuffer.put(rest);
    }
}

