/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.objectbus;

import de.hardcode.hq.objectbus.BusLine;
import de.hardcode.hq.objectbus.BusStation;
import de.hardcode.hq.objectbus.BusTicket;
import de.hardcode.hq.objectbus.Log;
import de.hardcode.hq.objectbus.NetStation;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;

public class NetLine
implements BusLine {
    private final ByteBuffer mBuffer;
    private final WritableByteChannel mChannel;
    private final NetStation mStation;
    public static final int DEFAULT_BUFFER_SIZE = 10240;
    private boolean mIsOperational = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    NetLine(NetStation station, WritableByteChannel c) {
        this.mStation = station;
        this.mChannel = c;
        this.mBuffer = ByteBuffer.allocate(10240);
        boolean bl = this.mIsOperational = this.mBuffer != null && this.mChannel.isOpen();
        if (this.isOperational()) {
            this.mStation.notifyEstablishedLine(this);
        }
    }

    public BusStation getBusStation() {
        return this.mStation;
    }

    public boolean isOperational() {
        return this.mIsOperational;
    }

    public void close() {
        Log.logger.fine("Line is closing.");
        try {
            this.mChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mStation.notifyDroppedLine(this);
        this.mIsOperational = false;
    }

    public synchronized void enter(BusTicket ticket) {
        block4: {
            try {
                this.storeTicket(ticket);
            }
            catch (BufferOverflowException bof) {
                try {
                    this.sendBus();
                    this.storeTicket(ticket);
                }
                catch (BufferOverflowException bof2) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError();
                }
            }
        }
    }

    private final synchronized void storeTicket(BusTicket t) throws BufferOverflowException {
        ByteBuffer cont = t.getTotalTicketBuffer();
        int remaining = this.mBuffer.limit() - this.mBuffer.position();
        if (remaining < cont.limit() + 2) {
            throw new BufferOverflowException();
        }
        this.mBuffer.putShort((short)cont.limit());
        this.mBuffer.put(cont);
    }

    public synchronized void sendBus() {
        try {
            this.mBuffer.flip();
            while (this.mBuffer.hasRemaining()) {
                int written = this.mChannel.write(this.mBuffer);
                if (!this.mBuffer.hasRemaining()) continue;
                Log.logger.finer("Could not write buffer at once. Sleeping....");
                Thread.sleep(1L);
            }
        }
        catch (AsynchronousCloseException acex) {
            Log.logger.fine("Channel has been closed asynchronously, closing line.");
            this.close();
        }
        catch (ClosedChannelException ccex) {
            Log.logger.fine("Channel has been closed, closing line.");
            this.close();
        }
        catch (IOException ioex) {
            Log.logger.fine("Problem sending bus, closing line.");
            this.close();
        }
        catch (InterruptedException iex) {
            Log.logger.warning("Received unexpected InterruptedException.");
        }
        this.mBuffer.clear();
    }

    static {
        $assertionsDisabled = !NetLine.class.desiredAssertionStatus();
    }
}

