/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.objectbus;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.objectbus.BusLine;
import de.hardcode.hq.objectbus.BusStation;
import de.hardcode.hq.objectbus.BusStationListener;
import de.hardcode.hq.objectbus.BusTicket;
import de.hardcode.hq.objectbus.BusTicketListener;
import de.hardcode.hq.objectbus.BusTicketListenerContainer;
import de.hardcode.hq.objectbus.LocalLine;
import de.hardcode.hq.objectbus.Log;
import java.util.ArrayList;

public class LocalStation
implements BusStation {
    private final ArrayList mStationListeners = new ArrayList();
    private BusStationListener[] mListenersArray = new BusStationListener[0];
    private Object[] mListenersArrayCache = this.mStationListeners.toArray();
    private final ArrayList mLines = new ArrayList();
    private BusLine[] mLineArray = new BusLine[0];
    private Object[] mLineArrayCache = new Object[0];
    private final BusTicketListenerContainer mTicketListeners = new BusTicketListenerContainer();

    public void close() {
        Log.logger.fine("Closing all BusLines.");
        this.flush();
        BusLine[] lines = this.getLines();
        for (int i = 0; i < lines.length; ++i) {
            BusLine line = lines[i];
            line.close();
        }
    }

    public final LocalLine createLine(LocalStation to) {
        LocalLine l = new LocalLine(this, to);
        LocalLine back = new LocalLine(to, this);
        l.setOpposite(back);
        back.setOpposite(l);
        return l;
    }

    protected void notifyStartHandleIncoming() {
        for (int i = 0; i < this.mListenersArray.length; ++i) {
            this.mListenersArray[i].startHandleIncoming();
        }
    }

    protected void notifyFinishedHandleIncoming() {
        for (int i = 0; i < this.mListenersArray.length; ++i) {
            this.mListenersArray[i].finishedHandleIncoming();
        }
    }

    protected void notifyEstablishedLine(BusLine line) {
        this.mLines.add(line);
        this.copyToLineArray();
        for (int i = 0; i < this.mListenersArray.length; ++i) {
            this.mListenersArray[i].establishedLine(line);
        }
    }

    protected void notifyDroppedLine(BusLine line) {
        this.mLines.remove(line);
        this.copyToLineArray();
        for (int i = 0; i < this.mListenersArray.length; ++i) {
            this.mListenersArray[i].droppedLine(line);
        }
    }

    protected void notifyIncomingBus(BusLine line, BusTicket ticket) {
        this.mTicketListeners.notifyIncomingBus(line, ticket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(BusStationListener w) {
        ArrayList arrayList = this.mStationListeners;
        synchronized (arrayList) {
            this.mStationListeners.add(w);
            this.copyToListenersArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(BusStationListener w) {
        ArrayList arrayList = this.mStationListeners;
        synchronized (arrayList) {
            this.mStationListeners.remove(w);
            this.copyToListenersArray();
        }
    }

    public void add(Identity id, BusTicketListener ticketlistener) {
        this.mTicketListeners.add(id, ticketlistener);
    }

    public void remove(Identity id, BusTicketListener ticketlistener) {
        this.mTicketListeners.remove(id, ticketlistener);
    }

    public BusLine[] getLines() {
        return this.mLineArray;
    }

    public void broadcast(BusTicket t, BusLine except) {
        BusLine[] lines = this.getLines();
        for (int i = 0; i < lines.length; ++i) {
            BusLine line = lines[i];
            if (line == except) continue;
            line.enter(t);
        }
    }

    public void flush() {
        for (int i = 0; i < this.mLineArray.length; ++i) {
            BusLine l = this.mLineArray[i];
            l.sendBus();
        }
    }

    private final void copyToLineArray() {
        if (this.mLines.size() != this.mLineArrayCache.length) {
            this.mLineArrayCache = new Object[this.mLines.size()];
            this.mLineArray = new BusLine[this.mLines.size()];
        }
        this.mLines.toArray(this.mLineArrayCache);
        for (int i = 0; i < this.mLineArray.length; ++i) {
            this.mLineArray[i] = (BusLine)this.mLineArrayCache[i];
        }
    }

    private final void copyToListenersArray() {
        if (this.mStationListeners.size() != this.mListenersArrayCache.length) {
            this.mListenersArrayCache = new Object[this.mStationListeners.size()];
            this.mListenersArray = new BusStationListener[this.mStationListeners.size()];
        }
        this.mStationListeners.toArray(this.mListenersArrayCache);
        for (int i = 0; i < this.mListenersArray.length; ++i) {
            this.mListenersArray[i] = (BusStationListener)this.mListenersArrayCache[i];
        }
    }
}

