/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.objectbus;

import de.hardcode.hq.objectbus.BusLine;
import de.hardcode.hq.objectbus.BusStation;
import de.hardcode.hq.objectbus.BusTicket;
import de.hardcode.hq.objectbus.LocalStation;
import java.util.ArrayList;
import java.util.Iterator;

public class LocalLine
implements BusLine {
    private final ArrayList mTickets = new ArrayList();
    private final LocalStation mEndPoint;
    private final LocalStation mStation;
    private boolean mIsOperational = true;
    private LocalLine mOppositeLine;

    LocalLine(LocalStation startpoint, LocalStation endpoint) {
        this.mStation = startpoint;
        this.mEndPoint = endpoint;
        this.mStation.notifyEstablishedLine(this);
    }

    void setOpposite(LocalLine l) {
        this.mOppositeLine = l;
    }

    public BusStation getBusStation() {
        return this.mStation;
    }

    public boolean isOperational() {
        return this.mIsOperational;
    }

    public void close() {
        this.mStation.notifyDroppedLine(this);
        this.mIsOperational = false;
        LocalLine op = this.mOppositeLine;
        this.mOppositeLine = null;
        if (null != op) {
            op.close();
        }
    }

    public synchronized void enter(BusTicket ticket) {
        this.mTickets.add(new BusTicket(ticket));
    }

    public synchronized void sendBus() {
        this.mEndPoint.notifyStartHandleIncoming();
        Iterator tickets = this.mTickets.iterator();
        while (tickets.hasNext()) {
            BusTicket t = (BusTicket)tickets.next();
            this.mEndPoint.notifyIncomingBus(this.mOppositeLine, t);
        }
        this.mTickets.clear();
        this.mEndPoint.notifyFinishedHandleIncoming();
    }
}

