/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.objectbus;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.objectbus.BusLine;
import de.hardcode.hq.objectbus.BusTicket;
import de.hardcode.hq.objectbus.BusTicketListener;
import de.hardcode.hq.objectbus.Log;
import java.util.ArrayList;
import java.util.HashMap;

class BusTicketListenerContainer {
    private final HashMap mMap = new HashMap();

    synchronized void add(Identity id, BusTicketListener listener) {
        ArrayList<BusTicketListener> list = (ArrayList<BusTicketListener>)this.mMap.get(id);
        if (null == list) {
            list = new ArrayList<BusTicketListener>();
            this.mMap.put(id, list);
        }
        list.add(listener);
    }

    synchronized void remove(Identity id, BusTicketListener listener) {
        ArrayList list = (ArrayList)this.mMap.get(id);
        if (null != list) {
            list.remove(listener);
        }
    }

    void notifyIncomingBus(BusLine line, BusTicket ticket) {
        int i;
        boolean isListened = false;
        ArrayList l = (ArrayList)this.mMap.get(null);
        if (null != l) {
            isListened = true;
            for (i = l.size() - 1; i >= 0; --i) {
                ticket.setPosition(0);
                ((BusTicketListener)l.get(i)).arrived(line, ticket);
            }
        }
        if (null != (l = (ArrayList)this.mMap.get(ticket.getIdentity()))) {
            isListened = true;
            for (i = l.size() - 1; i >= 0; --i) {
                ticket.setPosition(0);
                ((BusTicketListener)l.get(i)).arrived(line, ticket);
            }
        }
        if (!isListened) {
            Log.logger.warning("No client for ticket " + ticket.getIdentity());
        }
    }
}

