/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.objectbus;

import de.hardcode.hq.identity.Identifyable;
import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.identity.external.Externalizer;
import java.nio.ByteBuffer;

public class BusTicket
implements Identifyable {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    private final Identity mIdentity;
    private final ByteBuffer mTicketBuffer;
    private ByteBuffer mBuffer;
    private final int mHeaderSize;
    private int mSize = 0;
    private final boolean mIsOutGoing;

    BusTicket(ByteBuffer bb) {
        this.mBuffer = bb;
        this.mIdentity = this.getID();
        this.mTicketBuffer = this.mBuffer;
        this.mBuffer = this.mTicketBuffer.slice();
        this.mSize = this.mBuffer.limit();
        this.mHeaderSize = this.mTicketBuffer.position();
        this.mIsOutGoing = false;
    }

    BusTicket(BusTicket bt) {
        ByteBuffer src = bt.getTotalTicketBuffer();
        this.mBuffer = ByteBuffer.allocate(src.limit());
        this.mBuffer.put(src);
        this.mBuffer.flip();
        this.mIdentity = this.getID();
        this.mTicketBuffer = this.mBuffer;
        this.mBuffer = this.mTicketBuffer.slice();
        this.mSize = this.mBuffer.limit();
        this.mHeaderSize = this.mTicketBuffer.position();
        this.mIsOutGoing = bt.mIsOutGoing;
    }

    public BusTicket(Identity id) {
        this(id, 1024);
    }

    public BusTicket(Identity id, int capacity) {
        this.mIdentity = id;
        this.mBuffer = ByteBuffer.allocate(capacity);
        this.putID(id);
        this.mTicketBuffer = this.mBuffer;
        this.mBuffer = this.mTicketBuffer.slice();
        this.mSize = 0;
        this.mHeaderSize = this.mTicketBuffer.position();
        this.mIsOutGoing = true;
    }

    public final Identity getIdentity() {
        return this.mIdentity;
    }

    final ByteBuffer getTotalTicketBuffer() {
        this.mBuffer.limit(this.mSize);
        this.mBuffer.rewind();
        this.mTicketBuffer.limit(this.mHeaderSize + this.mSize);
        this.mTicketBuffer.rewind();
        return this.mTicketBuffer;
    }

    public final int getSize() {
        return this.mSize;
    }

    public final void clear() {
        this.mBuffer.clear();
        this.mSize = 0;
    }

    public final int getPosition() {
        return this.mBuffer.position();
    }

    public final void setPosition(int pos) {
        this.mBuffer.position(pos);
    }

    public final void rewind() {
        this.mBuffer.rewind();
    }

    private final void checkSize(int pos) {
        if (pos > this.mSize) {
            this.mSize = pos;
        }
    }

    public final void putByte(byte b) {
        this.mBuffer.put(b);
        this.checkSize(this.mBuffer.position());
    }

    public final void putByte(int index, byte b) {
        this.mBuffer.put(index, b);
        this.checkSize(index + 1);
    }

    public final void putBytes(byte[] src) {
        this.mBuffer.put(src);
        this.checkSize(this.mBuffer.position());
    }

    public final int putBytes(int index, byte[] src) {
        for (int i = 0; i < src.length; ++i) {
            this.mBuffer.put(index++, src[i]);
        }
        this.checkSize(index);
        return index;
    }

    public final void putBytes(byte[] src, int offset, int length) {
        this.mBuffer.put(src, offset, length);
        this.checkSize(this.mBuffer.position());
    }

    public final void putBytes(ByteBuffer src) {
        this.mBuffer.put(src);
        this.checkSize(this.mBuffer.position());
    }

    public final void putChar(char value) {
        this.mBuffer.putChar(value);
        this.checkSize(this.mBuffer.position());
    }

    public final void putChar(int index, char value) {
        this.mBuffer.putChar(index, value);
        this.checkSize(index + 1);
    }

    public final void putDouble(double value) {
        this.mBuffer.putDouble(value);
        this.checkSize(this.mBuffer.position());
    }

    public final void putDouble(int index, double value) {
        this.mBuffer.putDouble(index, value);
        this.checkSize(index + 8);
    }

    public final void putFloat(float value) {
        this.mBuffer.putFloat(value);
        this.checkSize(this.mBuffer.position());
    }

    public final void putFloat(int index, float value) {
        this.mBuffer.putFloat(index, value);
        this.checkSize(index + 4);
    }

    public final void putInt(int value) {
        this.mBuffer.putInt(value);
        this.checkSize(this.mBuffer.position());
    }

    public final void putInt(int index, int value) {
        this.mBuffer.putInt(index, value);
        this.checkSize(index + 4);
    }

    public final void putLong(long value) {
        this.mBuffer.putLong(value);
        this.checkSize(this.mBuffer.position());
    }

    public final void putLong(int index, long value) {
        this.mBuffer.putLong(index, value);
        this.checkSize(index + 8);
    }

    public final void putShort(short value) {
        this.mBuffer.putShort(value);
        this.checkSize(this.mBuffer.position());
    }

    public final void putShort(int index, short value) {
        this.mBuffer.putShort(index, value);
        this.checkSize(index + 2);
    }

    public final void putID(Identity id) {
        int pos = this.mBuffer.position();
        int len = Externalizer.toBytes(id, this.mBuffer, pos);
        this.mBuffer.position(pos + len);
        this.checkSize(pos + len);
    }

    public final int putID(int index, Identity id) {
        int len = Externalizer.toBytes(id, this.mBuffer, index);
        this.checkSize(index + len);
        return index + len;
    }

    public final void putASCIIString(String s) {
        byte[] bytes = s.getBytes();
        this.mBuffer.putShort((short)bytes.length);
        this.mBuffer.put(bytes);
        this.checkSize(this.mBuffer.position());
    }

    public final int putASCIIString(int index, String s) {
        byte[] bytes = s.getBytes();
        this.mBuffer.putShort(index, (short)bytes.length);
        this.putBytes(index + 2, bytes);
        this.checkSize(index + 2 + bytes.length);
        return index + 2 + bytes.length;
    }

    public final void putString(String s) {
        this.mBuffer.putShort((short)s.length());
        for (int i = 0; i < s.length(); ++i) {
            this.mBuffer.putChar(s.charAt(i));
        }
        this.checkSize(this.mBuffer.position());
    }

    public final int putString(int index, String s) {
        this.mBuffer.putShort(index, (short)s.length());
        for (int i = 0; i < s.length(); ++i) {
            this.mBuffer.putChar(index + 2 + i + i, s.charAt(i));
        }
        this.checkSize(index + 2 + s.length() * 2);
        return index + 2 + s.length() * 2;
    }

    public final byte getByte() {
        return this.mBuffer.get();
    }

    public final byte getByte(int index) {
        return this.mBuffer.get(index);
    }

    public final void getBytes(byte[] dst) {
        this.mBuffer.get(dst);
    }

    public final void getBytes(int index, byte[] dst) {
        this.getBytes(index, dst, 0, dst.length);
    }

    public final void getBytes(byte[] dst, int offset, int length) {
        this.mBuffer.get(dst, offset, length);
    }

    public final synchronized void getBytes(int index, byte[] dst, int offset, int length) {
        int savepos = this.mBuffer.position();
        this.mBuffer.position(index);
        this.mBuffer.get(dst, offset, length);
        this.mBuffer.position(savepos);
    }

    public final char getChar() {
        return this.mBuffer.getChar();
    }

    public final char getChar(int index) {
        return this.mBuffer.getChar(index);
    }

    public final double getDouble() {
        return this.mBuffer.getDouble();
    }

    public final double getDouble(int index) {
        return this.mBuffer.getDouble(index);
    }

    public final float getFloat() {
        return this.mBuffer.getFloat();
    }

    public final float getFloat(int index) {
        return this.mBuffer.getFloat(index);
    }

    public final int getInt() {
        return this.mBuffer.getInt();
    }

    public final int getInt(int index) {
        return this.mBuffer.getInt(index);
    }

    public final long getLong() {
        return this.mBuffer.getLong();
    }

    public final long getLong(int index) {
        return this.mBuffer.getLong(index);
    }

    public final short getShort() {
        return this.mBuffer.getShort();
    }

    public final short getShort(int index) {
        return this.mBuffer.getShort(index);
    }

    public final Identity getID() {
        return Externalizer.createIdentity(this.mBuffer, this.mBuffer.position());
    }

    public final Identity getID(int index) {
        return Externalizer.createIdentity(this.mBuffer, index);
    }

    public final String getASCIIString() {
        int len = this.mBuffer.getShort();
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            sb.append((char)this.mBuffer.get());
        }
        return sb.toString();
    }

    public final String getASCIIString(int index) {
        short len = this.mBuffer.getShort(index);
        StringBuffer sb = new StringBuffer(len);
        for (int i = index + 2; i < index + 2 + len; ++i) {
            sb.append((char)this.mBuffer.get(i));
        }
        return sb.toString();
    }

    public final String getString() {
        int len = this.mBuffer.getShort();
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            sb.append(this.mBuffer.getChar());
        }
        return sb.toString();
    }

    public final String getString(int index) {
        int len = this.mBuffer.getShort(index);
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            sb.append(this.mBuffer.getChar(index + 2 + i + i));
        }
        return sb.toString();
    }
}

