/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.location.motion;

import de.hardcode.hq.location.LocationData;
import de.hardcode.hq.location.motion.Motion;
import de.hardcode.util.QuatUtil;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class SmoothedMotion
implements Motion {
    private final Motion mBaseMotion;
    private final LocationData mLocData = new LocationData();
    private final Vector3f mTmpTrans = new Vector3f();
    private final Vector3f mTmpVel = new Vector3f();
    private final Vector3f mDistance = new Vector3f();
    private final Quat4f mSrcOrientation = new Quat4f();
    private final Quat4f mDstOrientation = new Quat4f();
    private float mTimeTrans = 500.0f;
    private float mTimeRot = 500.0f;
    private boolean mLocDataChanged = true;

    public SmoothedMotion(Motion base) {
        this.mBaseMotion = base;
    }

    public void setTranslationTimeConstant(float ms) {
        this.mTimeTrans = ms;
    }

    public void setRotationTimeConstant(float ms) {
        this.mTimeRot = ms;
    }

    public void setBaseData(LocationData data) {
        this.mLocData.set(data);
        this.mLocDataChanged = true;
    }

    public int move(LocationData data, long ms, float dt) {
        float t_rot;
        float t_trans = dt / this.mTimeTrans;
        if (t_trans > 1.0f) {
            t_trans = 1.0f;
        }
        if ((t_rot = dt / this.mTimeRot) > 1.0f) {
            t_rot = 1.0f;
        }
        data.acceleration().set((Tuple3f)this.mLocData.acceleration());
        data.turn().set((Tuple3f)this.mLocData.turn());
        float locDt = dt;
        if (this.mLocDataChanged) {
            locDt = ms - this.mLocData.getTimeStamp();
            this.mLocDataChanged = false;
        }
        this.mBaseMotion.move(this.mLocData, ms, locDt);
        int what = this.mBaseMotion.move(data, ms, dt);
        data.position().get(this.mTmpTrans);
        this.mLocData.position().get(this.mDistance);
        this.mDistance.sub((Tuple3f)this.mTmpTrans);
        this.mDistance.scale(t_trans);
        this.mTmpTrans.add((Tuple3f)this.mDistance);
        data.position().get(this.mSrcOrientation);
        this.mLocData.position().get(this.mDstOrientation);
        QuatUtil.slerp(this.mDstOrientation, this.mSrcOrientation, 1.0f - t_rot);
        data.velocity().get((Tuple3f)this.mTmpVel);
        this.mLocData.velocity().get((Tuple3f)this.mDistance);
        this.mDistance.sub((Tuple3f)this.mTmpVel);
        this.mDistance.scale(t_trans);
        data.velocity().add((Tuple3f)this.mDistance);
        data.spin().get((Tuple3f)this.mTmpVel);
        this.mLocData.spin().get((Tuple3f)this.mDistance);
        this.mDistance.sub((Tuple3f)this.mTmpVel);
        this.mDistance.scale(t_rot);
        data.spin().add((Tuple3f)this.mDistance);
        data.position().setTranslation(this.mTmpTrans);
        data.position().setRotation(this.mDstOrientation);
        return what;
    }
}

