/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.location.motion;

import de.hardcode.hq.location.LocationData;
import de.hardcode.hq.location.motion.Motion;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class EulerMotion
implements Motion {
    static final float sG = 9.8E-6f;
    private static final Vector3f G_EARTH = new Vector3f(0.0f, -9.8E-6f, 0.0f);
    private final Vector3f mTmpDeltaVelocity = new Vector3f();
    private final Vector3f mTmpDeltaTranslation = new Vector3f();
    private final Matrix3f mTmpRot = new Matrix3f();
    private final Vector3f mTmpTrans = new Vector3f();
    private final AxisAngle4f mTmpSpinAxisAngle = new AxisAngle4f();
    private final Matrix3f mTmpSpinRotation = new Matrix3f();

    public int move(LocationData data, long ms, float dt) {
        int what = 0;
        data.position().get(this.mTmpTrans);
        data.position().getRotationScale(this.mTmpRot);
        this.mTmpDeltaVelocity.scale(dt, (Tuple3f)data.acceleration());
        this.mTmpDeltaTranslation.scale(dt, (Tuple3f)data.velocity());
        this.mTmpDeltaTranslation.scaleAdd(0.5f * dt * dt, (Tuple3f)data.acceleration(), (Tuple3f)this.mTmpDeltaTranslation);
        this.mTmpTrans.add((Tuple3f)this.mTmpDeltaTranslation);
        this.mTmpSpinAxisAngle.set(data.spin(), data.spin().length() * dt);
        this.mTmpSpinRotation.set(this.mTmpSpinAxisAngle);
        this.mTmpRot.mul(this.mTmpSpinRotation, this.mTmpRot);
        data.position().set(this.mTmpRot, this.mTmpTrans, 1.0f);
        if ((double)this.mTmpDeltaTranslation.lengthSquared() > 0.0 || (double)this.mTmpSpinAxisAngle.z != 0.0) {
            what |= 1;
        }
        data.velocity().add((Tuple3f)this.mTmpDeltaVelocity);
        if ((double)this.mTmpDeltaTranslation.lengthSquared() > 0.0 || (double)this.mTmpSpinAxisAngle.z != 0.0) {
            what |= 1;
        }
        if ((double)this.mTmpDeltaVelocity.lengthSquared() > 0.0) {
            what |= 2;
        }
        data.setTimeStamp(ms);
        return what;
    }
}

