/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.location.motion;

import de.hardcode.hq.location.LocationData;
import de.hardcode.hq.location.motion.HyperEllipse;
import de.hardcode.hq.location.motion.Log;
import de.hardcode.hq.location.motion.Motion;
import javax.vecmath.Matrix3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class DeadReckoner {
    final float[] POSELLIPSE = new float[]{4.0f, 4.0f, 4.0f, 0.028900001f, 0.028900001f};
    float[] VELELLIPSE = new float[]{0.005f, 0.005f, 0.005f};
    float[] SPINELLIPSE = new float[]{0.003f, 0.003f, 0.003f};
    float[] ACCELLIPSE = new float[]{5.0E-5f, 5.0E-5f, 5.0E-5f};
    float[] TURNELLIPSE = new float[]{3.0E-5f, 3.0E-5f, 3.0E-5f};
    private static final Vector3f FORWARD = new Vector3f(0.0f, 0.0f, -1.0f);
    private static final Vector3f RIGHT = new Vector3f(1.0f, 0.0f, 0.0f);
    private final HyperEllipse mPosEllipse = new HyperEllipse(this.POSELLIPSE);
    private final HyperEllipse mVelEllipse = new HyperEllipse(this.VELELLIPSE);
    private final HyperEllipse mSpinEllipse = new HyperEllipse(this.SPINELLIPSE);
    private final HyperEllipse mAccEllipse = new HyperEllipse(this.ACCELLIPSE);
    private final HyperEllipse mTurnEllipse = new HyperEllipse(this.TURNELLIPSE);
    private final Motion mRefMotion;
    private final LocationData mRefData = new LocationData();
    private long mTimeStampLastUpdated = -1L;
    private final long MIN_INTERVAL = 100L;
    private long mTimeStampLastStats = -1L;
    private int mPassed;
    private int mDiscarded;
    private final knowndata mKnown = new knowndata();
    private final extradata mExtra = new extradata();
    private final comparedata mCmp = new comparedata();

    public DeadReckoner(Motion ref) {
        this.mRefMotion = ref;
    }

    public int eval(LocationData data, long ms, float dt) {
        int what = 0;
        this.mRefMotion.move(this.mRefData, ms, ms - this.mRefData.getTimeStamp());
        int updateneeded = this.needsUpdate(data);
        if (updateneeded != 0) {
            this.mRefData.set(data, 31);
            what = 31;
            this.mTimeStampLastUpdated = ms;
            ++this.mPassed;
        } else {
            ++this.mDiscarded;
        }
        long tensecs = ms / 10000L;
        if (tensecs > this.mTimeStampLastStats) {
            this.mTimeStampLastStats = tensecs;
            Log.logger.fine("Passed: " + this.mPassed + " discarded: " + this.mDiscarded + " ratio: " + (float)this.mPassed / (float)(this.mDiscarded + this.mPassed));
            this.mPassed = 0;
            this.mDiscarded = 0;
        }
        return what;
    }

    private int needsUpdate(LocationData data) {
        int ret = 0;
        this.mExtra.locdata.set(this.mRefData);
        this.mExtra.locdata.position().get(this.mExtra.trans);
        this.mExtra.locdata.position().getRotationScale(this.mExtra.rot);
        data.position().get(this.mKnown.trans);
        data.position().getRotationScale(this.mKnown.rot);
        this.mExtra.trans.sub((Tuple3f)this.mKnown.trans);
        this.mExtra.rot.transform((Tuple3f)FORWARD, (Tuple3f)this.mExtra.forward);
        this.mExtra.rot.transform((Tuple3f)RIGHT, (Tuple3f)this.mExtra.right);
        this.mKnown.rot.transform((Tuple3f)FORWARD, (Tuple3f)this.mKnown.forward);
        this.mKnown.rot.transform((Tuple3f)RIGHT, (Tuple3f)this.mKnown.right);
        this.mExtra.forward.sub((Tuple3f)this.mKnown.forward);
        this.mExtra.right.sub((Tuple3f)this.mKnown.right);
        float headingangle = this.mExtra.forward.lengthSquared();
        float rollangle = this.mExtra.right.lengthSquared();
        this.mCmp.pos[0] = this.mExtra.trans.x;
        this.mCmp.pos[1] = this.mExtra.trans.y;
        this.mCmp.pos[2] = this.mExtra.trans.z;
        this.mCmp.pos[3] = headingangle;
        this.mCmp.pos[4] = rollangle;
        if (!this.mPosEllipse.isInside(this.mCmp.pos)) {
            ret |= 1;
        }
        this.mExtra.locdata.velocity().sub((Tuple3f)data.velocity());
        this.mExtra.locdata.velocity().get(this.mCmp.vel);
        if (!this.mVelEllipse.isInside(this.mCmp.vel)) {
            ret |= 2;
        }
        this.mExtra.locdata.spin().sub((Tuple3f)data.spin());
        this.mExtra.locdata.spin().get(this.mCmp.spin);
        if (!this.mSpinEllipse.isInside(this.mCmp.spin)) {
            ret |= 4;
        }
        this.mExtra.locdata.acceleration().sub((Tuple3f)data.acceleration());
        this.mExtra.locdata.acceleration().get(this.mCmp.acc);
        if (!this.mAccEllipse.isInside(this.mCmp.acc)) {
            ret |= 8;
        }
        this.mExtra.locdata.turn().sub((Tuple3f)data.turn());
        this.mExtra.locdata.turn().get(this.mCmp.turn);
        if (!this.mTurnEllipse.isInside(this.mCmp.turn)) {
            ret |= 0x10;
        }
        return ret;
    }

    private final class comparedata {
        final float[] pos;
        final float[] vel;
        final float[] spin;
        final float[] acc;
        final float[] turn;

        private comparedata() {
            this.pos = new float[DeadReckoner.this.POSELLIPSE.length];
            this.vel = new float[DeadReckoner.this.VELELLIPSE.length];
            this.spin = new float[DeadReckoner.this.SPINELLIPSE.length];
            this.acc = new float[DeadReckoner.this.ACCELLIPSE.length];
            this.turn = new float[DeadReckoner.this.TURNELLIPSE.length];
        }
    }

    private final class extradata {
        final LocationData locdata = new LocationData();
        final Matrix3f rot = new Matrix3f();
        final Vector3f trans = new Vector3f();
        final Vector3f forward = new Vector3f();
        final Vector3f right = new Vector3f();

        private extradata() {
        }
    }

    private final class knowndata {
        final Matrix3f rot = new Matrix3f();
        final Vector3f trans = new Vector3f();
        final Vector3f forward = new Vector3f();
        final Vector3f right = new Vector3f();

        private knowndata() {
        }
    }
}

