/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.location.client;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.location.Location;
import de.hardcode.hq.location.LocationListener;
import de.hardcode.hq.location.Locations;
import de.hardcode.hq.objectbus.BusLine;
import de.hardcode.hq.objectbus.BusStation;
import de.hardcode.hq.objectbus.BusTicket;
import de.hardcode.hq.objectbus.BusTicketListener;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;

public class LocationsClient
implements BusTicketListener,
LocationListener {
    private final Locations mLocations;
    private final BusStation mStation;
    private final Identity mProtocolID;
    private final Identity mServiceProtocolID;
    private final BusTicket mTicket;
    private final preallocated mTmp = new preallocated();

    public LocationsClient(BusStation station, Identity serverProtocolID, Identity serviceProtocolID, Locations locations) {
        this.mStation = station;
        this.mProtocolID = serverProtocolID;
        this.mServiceProtocolID = serviceProtocolID;
        this.mLocations = locations;
        this.mTicket = new BusTicket(this.mProtocolID);
        this.mLocations.addListener(this);
        this.mStation.add(this.mProtocolID, this);
    }

    public void close() {
        this.mStation.remove(this.mProtocolID, this);
        this.mLocations.removeListener(this);
    }

    public void download() {
        BusTicket t = new BusTicket(this.mServiceProtocolID);
        this.mStation.broadcast(t, null);
        this.mTicket.clear();
    }

    public void arrived(BusLine l, BusTicket t) {
        t.setPosition(0);
        Identity id = t.getID();
        Location loc = this.guaranteedResolve(id);
        loc.startUpdate(this);
        long timestamp = t.getLong();
        byte what = t.getByte();
        if ((what & 1) != 0) {
            for (int col = 0; col < 4; ++col) {
                for (int row = 0; row < 3; ++row) {
                    this.mTmp.matrix.setElement(row, col, t.getFloat());
                }
            }
            loc.setPosition(this.mTmp.matrix);
        }
        if ((what & 2) != 0) {
            this.mTmp.vector.set(t.getFloat(), t.getFloat(), t.getFloat());
            loc.setVelocity(this.mTmp.vector);
        }
        if ((what & 4) != 0) {
            this.mTmp.vector.set(t.getFloat(), t.getFloat(), t.getFloat());
            loc.setSpin(this.mTmp.vector);
        }
        if ((what & 8) != 0) {
            this.mTmp.vector.set(t.getFloat(), t.getFloat(), t.getFloat());
            loc.setAcceleration(this.mTmp.vector);
        }
        if ((what & 0x10) != 0) {
            this.mTmp.vector.set(t.getFloat(), t.getFloat(), t.getFloat());
            loc.setTurn(this.mTmp.vector);
        }
        loc.finishUpdate(timestamp);
    }

    private final Location guaranteedResolve(Identity id) {
        Location s = this.mLocations.resolve(id);
        if (null == s) {
            s = this.mLocations.createLocation(id, this);
        }
        return s;
    }

    public void changed(Location loc, int what, Object initiator) {
        if (initiator != this) {
            this.mTicket.clear();
            this.mTicket.putID(loc.getIdentity());
            this.mTicket.putLong(loc.getTimeStamp());
            this.mTicket.putByte((byte)what);
            if ((what & 1) != 0) {
                Matrix4f pos = loc.getPosition();
                for (int col = 0; col < 4; ++col) {
                    for (int row = 0; row < 3; ++row) {
                        this.mTicket.putFloat(pos.getElement(row, col));
                    }
                }
            }
            if ((what & 2) != 0) {
                Vector3f vel = loc.getVelocity();
                this.mTicket.putFloat(vel.x);
                this.mTicket.putFloat(vel.y);
                this.mTicket.putFloat(vel.z);
            }
            if ((what & 4) != 0) {
                Vector3f spin = loc.getSpin();
                this.mTicket.putFloat(spin.x);
                this.mTicket.putFloat(spin.y);
                this.mTicket.putFloat(spin.z);
            }
            if ((what & 8) != 0) {
                Vector3f acc = loc.getAcceleration();
                this.mTicket.putFloat(acc.x);
                this.mTicket.putFloat(acc.y);
                this.mTicket.putFloat(acc.z);
            }
            if ((what & 0x10) != 0) {
                Vector3f turn = loc.getTurn();
                this.mTicket.putFloat(turn.x);
                this.mTicket.putFloat(turn.y);
                this.mTicket.putFloat(turn.z);
            }
            this.mStation.broadcast(this.mTicket, null);
        }
    }

    public void created(Location which, Object initiator) {
    }

    public void eliminated(Location which, Object initiator) {
    }

    class preallocated {
        final Vector3f vector = new Vector3f();
        final Matrix4f matrix = new Matrix4f();

        preallocated() {
        }
    }
}

