/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.location;

import de.hardcode.hq.identity.IdentifyableRegistry;
import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.location.Location;
import de.hardcode.hq.location.LocationImpl;
import de.hardcode.hq.location.LocationListener;
import java.util.ArrayList;
import java.util.Iterator;

public class Locations {
    private final IdentifyableRegistry mIdentRegistry = new IdentifyableRegistry();
    private final ArrayList mListeners = new ArrayList();

    public final Location createLocation(Identity id, Object initiator) {
        Location loc = this.resolve(id);
        if (null != loc) {
            return loc;
        }
        loc = new LocationImpl(this, id);
        this.mIdentRegistry.register(loc);
        this.notifyCreated(loc, initiator);
        return loc;
    }

    public final Iterator getLocations() {
        return this.mIdentRegistry.getIdentifyables();
    }

    public void eliminate(Location loc, Object initiator) {
        this.mIdentRegistry.unregister(loc);
        this.notifyEliminated(loc, initiator);
    }

    public final Location resolve(Identity id) {
        return (Location)this.mIdentRegistry.resolve(id);
    }

    public final void addListener(LocationListener l) {
        this.mListeners.add(l);
    }

    public final void removeListener(LocationListener l) {
        this.mListeners.remove(l);
    }

    final void notifyCreated(Location which, Object initiator) {
        int n = this.mListeners.size();
        for (int i = n - 1; i >= 0; --i) {
            LocationListener l = (LocationListener)this.mListeners.get(i);
            l.created(which, initiator);
        }
    }

    final void notifyEliminated(Location which, Object initiator) {
        int n = this.mListeners.size();
        for (int i = n - 1; i >= 0; --i) {
            LocationListener l = (LocationListener)this.mListeners.get(i);
            l.eliminated(which, initiator);
        }
    }

    final void notifyChanged(Location which, int what, Object initiator) {
        int n = this.mListeners.size();
        for (int i = n - 1; i >= 0; --i) {
            LocationListener l = (LocationListener)this.mListeners.get(i);
            l.changed(which, what, initiator);
        }
    }
}

