/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.location;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.location.Location;
import de.hardcode.hq.location.LocationData;
import de.hardcode.hq.location.Locations;
import de.hardcode.hq.util.UpdateLock;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class LocationImpl
implements Location {
    private final Locations mLocations;
    private Identity mIdentity;
    private final UpdateLock mLock = new UpdateLock();
    private final LocationData mData = new LocationData();
    private int mWhatChangedFlags = 0;

    LocationImpl(Locations locs, Identity id) {
        this.mLocations = locs;
        this.mIdentity = id;
    }

    public final Identity getIdentity() {
        return this.mIdentity;
    }

    public synchronized void startUpdate(Object initiator) {
        this.mLock.lock(initiator);
        this.mWhatChangedFlags = 0;
    }

    public synchronized void finishUpdate(long timestamp) {
        if (0 != this.mWhatChangedFlags) {
            this.mData.setTimeStamp(timestamp);
        }
        this.mLocations.notifyChanged(this, this.mWhatChangedFlags, this.mLock.getOwner());
        this.mLock.unlock();
    }

    public final long getTimeStamp() {
        return this.mData.getTimeStamp();
    }

    public final void setPosition(Matrix4f m) {
        this.mLock.verifyIsLocked();
        this.mData.position().set(m);
        this.mWhatChangedFlags |= 1;
    }

    public final void setVelocity(Vector3f v) {
        this.mLock.verifyIsLocked();
        this.mData.velocity().set((Tuple3f)v);
        this.mWhatChangedFlags |= 2;
    }

    public final void setSpin(Vector3f s) {
        this.mLock.verifyIsLocked();
        this.mData.spin().set((Tuple3f)s);
        this.mWhatChangedFlags |= 4;
    }

    public final void setAcceleration(Vector3f a) {
        this.mLock.verifyIsLocked();
        this.mData.acceleration().set((Tuple3f)a);
        this.mWhatChangedFlags |= 8;
    }

    public final void setTurn(Vector3f t) {
        this.mLock.verifyIsLocked();
        this.mData.turn().set((Tuple3f)t);
        this.mWhatChangedFlags |= 0x10;
    }

    public final void setData(LocationData l) {
        this.mLock.verifyIsLocked();
        this.mData.set(l);
        this.mWhatChangedFlags |= 0x1F;
    }

    public final void setData(LocationData l, int what) {
        this.mLock.verifyIsLocked();
        if (0 != (what & 1)) {
            this.mData.position().set(l.position());
        }
        if (0 != (what & 2)) {
            this.mData.velocity().set((Tuple3f)l.velocity());
        }
        if (0 != (what & 4)) {
            this.mData.spin().set((Tuple3f)l.spin());
        }
        if (0 != (what & 8)) {
            this.mData.acceleration().set((Tuple3f)l.acceleration());
        }
        if (0 != (what & 0x10)) {
            this.mData.turn().set((Tuple3f)l.turn());
        }
        this.mWhatChangedFlags |= what;
    }

    public final Matrix4f getPosition() {
        return new Matrix4f(this.mData.position());
    }

    public final Vector3f getVelocity() {
        return new Vector3f(this.mData.velocity());
    }

    public final Vector3f getSpin() {
        return new Vector3f(this.mData.spin());
    }

    public final Vector3f getAcceleration() {
        return new Vector3f(this.mData.acceleration());
    }

    public final Vector3f getTurn() {
        return new Vector3f(this.mData.turn());
    }

    public final LocationData getData() {
        return new LocationData(this.mData);
    }

    public final void getPosition(Matrix4f pos) {
        pos.set(this.mData.position());
    }

    public final void getVelocity(Vector3f vel) {
        vel.set((Tuple3f)this.mData.velocity());
    }

    public final void getSpin(Vector3f spin) {
        spin.set((Tuple3f)this.mData.spin());
    }

    public final void getAcceleration(Vector3f acc) {
        acc.set((Tuple3f)this.mData.acceleration());
    }

    public final void getTurn(Vector3f turn) {
        turn.set((Tuple3f)this.mData.turn());
    }

    public final void getData(LocationData data) {
        data.set(this.mData);
    }
}

