/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.location;

import de.hardcode.hq.location.LocationConstants;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class LocationData
implements LocationConstants {
    private final Matrix4f mPosition = new Matrix4f();
    private final Vector3f mVelocity = new Vector3f();
    private final Vector3f mSpin = new Vector3f();
    private final Vector3f mAcceleration = new Vector3f();
    private final Vector3f mTurn = new Vector3f();
    private long mTimeStamp = -1L;

    public LocationData() {
        this.mPosition.setIdentity();
    }

    public LocationData(LocationData rhs) {
        this.set(rhs);
    }

    public final long getTimeStamp() {
        return this.mTimeStamp;
    }

    public final void setTimeStamp(long timestamp) {
        this.mTimeStamp = timestamp;
    }

    public final void set(LocationData rhs) {
        this.mPosition.set(rhs.position());
        this.mVelocity.set((Tuple3f)rhs.velocity());
        this.mSpin.set((Tuple3f)rhs.spin());
        this.mAcceleration.set((Tuple3f)rhs.acceleration());
        this.mTurn.set((Tuple3f)rhs.turn());
        this.mTimeStamp = rhs.getTimeStamp();
    }

    public final void set(LocationData rhs, int what) {
        if (0 != (what & 1)) {
            this.mPosition.set(rhs.position());
        }
        if (0 != (what & 2)) {
            this.mVelocity.set((Tuple3f)rhs.velocity());
        }
        if (0 != (what & 4)) {
            this.mSpin.set((Tuple3f)rhs.spin());
        }
        if (0 != (what & 8)) {
            this.mAcceleration.set((Tuple3f)rhs.acceleration());
        }
        if (0 != (what & 0x10)) {
            this.mTurn.set((Tuple3f)rhs.turn());
        }
        this.mTimeStamp = rhs.getTimeStamp();
    }

    public final Matrix4f position() {
        return this.mPosition;
    }

    public final Vector3f velocity() {
        return this.mVelocity;
    }

    public final Vector3f spin() {
        return this.mSpin;
    }

    public final Vector3f acceleration() {
        return this.mAcceleration;
    }

    public final Vector3f turn() {
        return this.mTurn;
    }
}

