/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.identity.external;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.identity.LongIdentity;
import de.hardcode.hq.identity.external.Externalizer;
import java.nio.ByteBuffer;

class LongExternalizer
extends Externalizer {
    private static final int LONG_SIZE = 8;

    LongExternalizer() {
    }

    protected int toBytesInternal(Identity id, ByteBuffer buffer, int startpos, boolean asScope) {
        LongIdentity lid = (LongIdentity)id;
        long l = lid.getLong();
        int len = this.putTagByte((byte)4, buffer, startpos, asScope);
        buffer.putLong(startpos += len, l);
        return len + 8;
    }

    protected Identity tryToCreate(Identity scope, ByteBuffer buffer, int startpos) {
        LongIdentity id = null;
        byte b = LongExternalizer.getTagByte(buffer, startpos);
        if (4 == LongExternalizer.getIdentityTypeID(b)) {
            buffer.position(startpos + 1 + 8);
            long value = buffer.getLong(startpos + 1);
            id = new LongIdentity(scope, value);
        }
        return id;
    }
}

