/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.identity.external;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.identity.external.ByteExternalizer;
import de.hardcode.hq.identity.external.LongExternalizer;
import de.hardcode.hq.identity.external.NameExternalizer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;

public abstract class Externalizer {
    static final byte SCOPE_MASK = -128;
    static final byte ID_TYPE_MASK = 127;
    static final byte SINGLE_BYTE_MASK = 64;
    static final int SINGLE_BYTE_RANGE = 64;
    static final byte SINGLE_BYTEVALUE_MASK = 63;
    static final byte BYTE_ID = 1;
    static final byte SHORT_ID = 2;
    static final byte INT_ID = 3;
    static final byte LONG_ID = 4;
    static final byte STRING_ID = 5;
    private static final HashMap mExternalizers = new HashMap();
    static /* synthetic */ Class class$de$hardcode$hq$identity$ByteIdentity;
    static /* synthetic */ Class class$de$hardcode$hq$identity$LongIdentity;
    static /* synthetic */ Class class$de$hardcode$hq$identity$NamedIdentity;

    protected Externalizer() {
    }

    public static Externalizer get(Class idclass) {
        return (Externalizer)mExternalizers.get(idclass);
    }

    protected int toBytesInternal(Identity id, ByteBuffer buffer, int startpos, boolean asScope) {
        return 0;
    }

    private static int toBytesHandleScope(Identity id, ByteBuffer buffer, int startpos, boolean asScope) {
        int len = 0;
        Identity scopeid = id.getScope();
        if (null != scopeid) {
            int scopelen = Externalizer.toBytesHandleScope(scopeid, buffer, startpos, true);
            startpos += scopelen;
            len += scopelen;
        }
        int idlen = Externalizer.toBytesNoScope(id, buffer, startpos, asScope);
        return len += idlen;
    }

    private static final int toBytesNoScope(Identity id, ByteBuffer buffer, int startpos, boolean asScope) {
        return Externalizer.get(id.getClass()).toBytesInternal(id, buffer, startpos, asScope);
    }

    protected final int putTagByte(byte tag, ByteBuffer b, int pos, boolean asScope) {
        if (asScope) {
            tag = (byte)(tag | 0xFFFFFF80);
        }
        b.put(pos, tag);
        return 1;
    }

    public static final int toBytes(Identity id, ByteBuffer buffer, int startpos) {
        return Externalizer.toBytesHandleScope(id, buffer, startpos, false);
    }

    protected abstract Identity tryToCreate(Identity var1, ByteBuffer var2, int var3);

    protected static final byte getTagByte(ByteBuffer buffer, int startpos) {
        byte b = buffer.get(startpos);
        return b;
    }

    protected static final byte getIdentityTypeID(byte b) {
        b = (byte)(b & 0x7F);
        return b;
    }

    protected static final boolean isScope(byte b) {
        return 0 != (b & 0xFFFFFF80);
    }

    public static final Identity createIdentity(ByteBuffer buffer, int startpos) {
        Identity scope = null;
        while (Externalizer.isScope(Externalizer.getTagByte(buffer, startpos))) {
            if (null == (scope = Externalizer.createIdentityInternal(scope, buffer, startpos))) {
                return null;
            }
            startpos = buffer.position();
        }
        Identity id = Externalizer.createIdentityInternal(scope, buffer, startpos);
        return id;
    }

    private static final Identity createIdentityInternal(Identity scope, ByteBuffer buffer, int startpos) {
        Iterator exts = mExternalizers.values().iterator();
        while (exts.hasNext()) {
            Externalizer e = (Externalizer)exts.next();
            Identity id = e.tryToCreate(scope, buffer, startpos);
            if (null == id) continue;
            return id;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        mExternalizers.put(class$de$hardcode$hq$identity$ByteIdentity == null ? (class$de$hardcode$hq$identity$ByteIdentity = Externalizer.class$("de.hardcode.hq.identity.ByteIdentity")) : class$de$hardcode$hq$identity$ByteIdentity, new ByteExternalizer());
        mExternalizers.put(class$de$hardcode$hq$identity$LongIdentity == null ? (class$de$hardcode$hq$identity$LongIdentity = Externalizer.class$("de.hardcode.hq.identity.LongIdentity")) : class$de$hardcode$hq$identity$LongIdentity, new LongExternalizer());
        mExternalizers.put(class$de$hardcode$hq$identity$NamedIdentity == null ? (class$de$hardcode$hq$identity$NamedIdentity = Externalizer.class$("de.hardcode.hq.identity.NamedIdentity")) : class$de$hardcode$hq$identity$NamedIdentity, new NameExternalizer());
    }
}

