/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.identity.external;

import de.hardcode.hq.identity.ByteIdentity;
import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.identity.external.Externalizer;
import java.nio.ByteBuffer;

class ByteExternalizer
extends Externalizer {
    ByteExternalizer() {
    }

    protected int toBytesInternal(Identity id, ByteBuffer buffer, int startpos, boolean asScope) {
        int len;
        ByteIdentity bid = (ByteIdentity)id;
        byte b = bid.getByte();
        if (b >= 0 && b < 64) {
            b = (byte)(b | 0x40);
            len = this.putTagByte(b, buffer, startpos, asScope);
        } else {
            len = this.putTagByte((byte)1, buffer, startpos, asScope);
            buffer.put(startpos += len, b);
            ++len;
        }
        return len;
    }

    protected Identity tryToCreate(Identity scope, ByteBuffer buffer, int startpos) {
        ByteIdentity id = null;
        byte b = ByteExternalizer.getTagByte(buffer, startpos);
        if (0 != (b & 0x40)) {
            buffer.position(startpos + 1);
            b = (byte)(b & 0x3F);
            id = new ByteIdentity(scope, b);
        } else if (1 == ByteExternalizer.getIdentityTypeID(b)) {
            buffer.position(startpos + 2);
            byte valuebyte = buffer.get(startpos + 1);
            id = new ByteIdentity(scope, valuebyte);
        }
        return id;
    }
}

