/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.identity;

import de.hardcode.hq.identity.Identity;
import java.util.Random;

public class LongIdentity
extends Identity {
    private final long mID;
    private String mStringRep = null;
    private static final Random sRandom = new Random();

    public LongIdentity(Identity scope, long id) {
        super(scope);
        this.mID = id;
    }

    public LongIdentity(long id) {
        super(null);
        this.mID = id;
    }

    public static final LongIdentity createRandom(Identity scope) {
        return new LongIdentity(scope, sRandom.nextLong());
    }

    public static final void seed(long seed) {
        sRandom.setSeed(seed);
    }

    public final long getLong() {
        return this.mID;
    }

    public boolean isSameAs(Identity id) {
        if (super.isSameAs(id)) {
            return ((LongIdentity)id).getLong() == this.getLong();
        }
        return false;
    }

    public int hashCode() {
        int hc = super.hashCode();
        hc = (int)((long)hc ^ this.mID & 0xFFFFFFFFL);
        hc = (int)((long)hc ^ this.mID >> 32);
        return hc;
    }

    public String toString() {
        if (null == this.mStringRep) {
            this.mStringRep = this.getScopeString() + "long{" + this.mID + "}";
        }
        return this.mStringRep;
    }
}

