/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.hqinsight.registry;

import de.hardcode.hq.hqinsight.ID;
import de.hardcode.hq.identity.Identifyable;
import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.objectbus.BusStation;
import de.hardcode.hq.registry.IdentitySet;
import de.hardcode.hq.registry.Registry;
import de.hardcode.hq.registry.RegistryListener;
import de.hardcode.hq.registry.client.RegistryClient;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class RegistryTree
extends JTree
implements RegistryListener {
    private final Registry mRegistry;
    private final RegistryClient mClient;
    private final IdentifyableTreeNode mRoot = new IdentifyableTreeNode(null, true);
    private final DefaultTreeModel mModel = new DefaultTreeModel(this.mRoot);

    public RegistryTree(BusStation stat, Registry reg) {
        this.setModel(this.mModel);
        this.mRegistry = reg;
        this.mClient = new RegistryClient(stat, ID.REGISTRY, ID.REGISTRY_SERVICE, reg);
        reg.addListener(this);
        this.setPreferredSize(new Dimension(200, 200));
        this.setRootVisible(false);
        this.mClient.download();
        stat.flush();
    }

    public void close() {
        this.mClient.close();
        this.mRegistry.removeListener(this);
    }

    private ArrayList findNodes(Identity id) {
        ArrayList found = new ArrayList();
        this.collectNodes(id, this.mRoot, found);
        return found;
    }

    private void collectNodes(Identity id, IdentifyableTreeNode start, ArrayList found) {
        for (int i = 0; i < start.getChildCount(); ++i) {
            IdentifyableTreeNode child = (IdentifyableTreeNode)start.getChildAt(i);
            if (child.getIdentity().isSameAs(id)) {
                found.add(child);
            }
            this.collectNodes(id, child, found);
        }
    }

    private void parseNode(IdentifyableTreeNode n) {
        if (!n.isIdSet()) {
            return;
        }
        n.removeAllChildren();
        IdentitySet s = this.mRegistry.resolve(n.getIdentity());
        Iterator subsets = s.getSubsets();
        while (subsets.hasNext()) {
            IdentitySet subset = (IdentitySet)subsets.next();
            IdentifyableTreeNode newnode = new IdentifyableTreeNode(subset.getIdentity(), true);
            n.add(newnode);
            this.parseNode(newnode);
        }
        Iterator members = s.getMembers();
        while (members.hasNext()) {
            Identity member = (Identity)members.next();
            IdentifyableTreeNode newnode = new IdentifyableTreeNode(member, false);
            n.add(newnode);
        }
        this.mModel.nodeStructureChanged(n);
    }

    private void establishAsRoot(IdentitySet idset) {
        for (int i = 0; i < this.mRoot.getChildCount(); ++i) {
            IdentifyableTreeNode child = (IdentifyableTreeNode)this.mRoot.getChildAt(i);
            if (!child.getIdentity().isSameAs(idset.getIdentity())) continue;
            return;
        }
        IdentifyableTreeNode newnode = new IdentifyableTreeNode(idset.getIdentity(), true);
        this.mModel.insertNodeInto(newnode, this.mRoot, this.mRoot.getChildCount());
    }

    private void addNode(IdentitySet where, Identity id, boolean asIdSet) {
        ArrayList wherenodes = this.findNodes(where.getIdentity());
        for (int i = 0; i < wherenodes.size(); ++i) {
            IdentifyableTreeNode wherenode = (IdentifyableTreeNode)wherenodes.get(i);
            IdentifyableTreeNode newnode = new IdentifyableTreeNode(id, asIdSet);
            this.mModel.insertNodeInto(newnode, wherenode, wherenode.getChildCount());
            if (!asIdSet) continue;
            this.parseNode(newnode);
        }
    }

    private void removeNode(Identity id) {
        ArrayList nodes = this.findNodes(id);
        for (int i = 0; i < nodes.size(); ++i) {
            IdentifyableTreeNode node = (IdentifyableTreeNode)nodes.get(i);
            this.mModel.removeNodeFromParent(node);
        }
    }

    private void removeNodeFrom(IdentitySet where, Identity id) {
        ArrayList nodes = this.findNodes(where.getIdentity());
        for (int i = 0; i < nodes.size(); ++i) {
            IdentifyableTreeNode node = (IdentifyableTreeNode)nodes.get(i);
            for (int j = 0; j < node.getChildCount(); ++j) {
                IdentifyableTreeNode child = (IdentifyableTreeNode)node.getChildAt(j);
                if (!child.getIdentity().isSameAs(id)) continue;
                this.mModel.removeNodeFromParent(child);
            }
        }
    }

    public void addedMember(IdentitySet where, Identity what, Object initiator) {
        this.establishAsRoot(where);
        this.addNode(where, what, false);
    }

    public void addedSubset(IdentitySet where, IdentitySet what, Object initiator) {
        this.establishAsRoot(where);
        this.establishAsRoot(what);
        this.addNode(where, what.getIdentity(), true);
    }

    public void eliminated(IdentitySet which, Object initiator) {
        this.removeNode(which.getIdentity());
    }

    public void removedMember(IdentitySet where, Identity what, Object initiator) {
        this.removeNodeFrom(where, what);
    }

    public void removedSubset(IdentitySet where, IdentitySet what, Object initiator) {
        this.removeNodeFrom(where, what.getIdentity());
    }

    private final class IdentifyableTreeNode
    extends DefaultMutableTreeNode
    implements Identifyable {
        final boolean mIsIdSet;

        IdentifyableTreeNode(Identity id, boolean asIdSet) {
            super(id);
            this.mIsIdSet = asIdSet;
        }

        public Identity getIdentity() {
            return (Identity)this.getUserObject();
        }

        public boolean isIdSet() {
            return this.mIsIdSet;
        }

        public boolean representsSet() {
            return null != RegistryTree.this.mRegistry.resolve(this.getIdentity());
        }

        public boolean isLeaf() {
            return !this.mIsIdSet;
        }
    }
}

