/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.hqinsight.property;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.property.Properties;
import de.hardcode.hq.property.PropertyListener;
import de.hardcode.hq.property.PropertySet;
import de.hardcode.hq.property.Value;
import de.hardcode.hq.property.changes.Change;
import de.hardcode.hq.property.changes.Changes;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class PropertyTableModel
implements TreeModel,
PropertyListener {
    private final Properties mProperties;
    private final ArrayList mSetNodes = new ArrayList();
    private final ArrayList mListeners = new ArrayList();
    private static final Object ROOT = new Object();

    public PropertyTableModel(Properties props) {
        this.mProperties = props;
        Iterator sets = props.getPropertySets();
        while (sets.hasNext()) {
            PropertySet set = (PropertySet)sets.next();
            this.establishSetNode(set);
        }
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.mListeners.add(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.mListeners.remove(l);
    }

    public Object getChild(Object parent, int index) {
        if (parent == ROOT) {
            return this.mSetNodes.get(index);
        }
        if (parent instanceof SetNode) {
            return ((SetNode)parent).get(index);
        }
        return null;
    }

    public int getChildCount(Object parent) {
        if (parent == ROOT) {
            return this.mSetNodes.size();
        }
        if (parent instanceof SetNode) {
            return ((SetNode)parent).getCount();
        }
        return 0;
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent == ROOT) {
            return this.mSetNodes.indexOf(child);
        }
        if (parent instanceof SetNode) {
            return ((SetNode)parent).indexOf((ValueNode)child);
        }
        return -1;
    }

    public Object getRoot() {
        return ROOT;
    }

    public boolean isLeaf(Object node) {
        return node instanceof ValueNode;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException("No user node changes allowed!");
    }

    public void changed(PropertySet which, Object initiator) {
        SetNode setnode = this.establishSetNode(which);
        Changes chgs = which.getChanges();
        int chgcount = chgs.getChangeCount();
        for (int i = 0; i < chgcount; ++i) {
            Change c = chgs.getChange(i);
            ValueNode valnode = setnode.get(c.getValue().getIdentity());
            if (valnode != null) {
                this.notifyValueChanged(valnode);
                continue;
            }
            valnode = new ValueNode(setnode, c.getValue());
            this.notifyStructChanged(setnode);
        }
    }

    public void created(PropertySet which, Object initiator) {
        this.establishSetNode(which);
    }

    public void eliminated(PropertySet which, Object initiator) {
        int target = this.findSetNode(which.getIdentity());
        if (target != -1) {
            this.mSetNodes.remove(target);
            this.notifyStructChanged();
        }
    }

    private final int findSetNode(Identity id) {
        int count = this.mSetNodes.size();
        for (int i = 0; i < count; ++i) {
            if (!((SetNode)this.mSetNodes.get(i)).hasID(id)) continue;
            return i;
        }
        return -1;
    }

    private final SetNode establishSetNode(PropertySet set) {
        SetNode setnode;
        int target = this.findSetNode(set.getIdentity());
        if (target == -1) {
            setnode = new SetNode(set);
            this.mSetNodes.add(setnode);
            this.notifyStructChanged();
            Iterator values = set.getValues();
            while (values.hasNext()) {
                ValueNode valuenode = new ValueNode(setnode, (Value)values.next());
            }
            this.notifyStructChanged(setnode);
        } else {
            setnode = (SetNode)this.mSetNodes.get(target);
        }
        return setnode;
    }

    void notifyStructChanged() {
        Object[] path = new Object[]{ROOT};
        TreeModelEvent evt = new TreeModelEvent((Object)this, path);
        int count = this.mListeners.size();
        for (int i = 0; i < count; ++i) {
            TreeModelListener l = (TreeModelListener)this.mListeners.get(i);
            l.treeStructureChanged(evt);
        }
    }

    void notifyStructChanged(SetNode setnode) {
        Object[] path = new Object[]{ROOT, setnode};
        TreeModelEvent evt = new TreeModelEvent((Object)this, path);
        int count = this.mListeners.size();
        for (int i = 0; i < count; ++i) {
            TreeModelListener l = (TreeModelListener)this.mListeners.get(i);
            l.treeStructureChanged(evt);
        }
    }

    void notifyValueChanged(ValueNode valnode) {
        Object[] path = new Object[]{ROOT, valnode.getParent(), valnode};
        TreeModelEvent evt = new TreeModelEvent((Object)this, path);
        int count = this.mListeners.size();
        for (int i = 0; i < count; ++i) {
            TreeModelListener l = (TreeModelListener)this.mListeners.get(i);
            l.treeNodesChanged(evt);
        }
    }

    private static class ValueNode {
        private final SetNode mSetNode;
        private final Value mVal;

        ValueNode(SetNode s, Value v) {
            this.mSetNode = s;
            this.mVal = v;
            s.addValueNode(this);
        }

        SetNode getParent() {
            return this.mSetNode;
        }

        public String toString() {
            return this.mVal.toString();
        }

        boolean hasID(Identity id) {
            return id.isSameAs(this.mVal.getIdentity());
        }
    }

    private static class SetNode {
        private final PropertySet mSet;
        private final ArrayList mValueNodes = new ArrayList();

        SetNode(PropertySet set) {
            this.mSet = set;
        }

        void clear() {
            this.mValueNodes.clear();
        }

        public String toString() {
            return this.mSet.getIdentity().toString();
        }

        boolean hasID(Identity id) {
            return id.isSameAs(this.mSet.getIdentity());
        }

        void addValueNode(ValueNode node) {
            this.mValueNodes.add(node);
        }

        void removeValueNode(ValueNode node) {
            this.mValueNodes.remove(node);
        }

        int indexOf(ValueNode node) {
            return this.mValueNodes.indexOf(node);
        }

        ValueNode get(int i) {
            return (ValueNode)this.mValueNodes.get(i);
        }

        ValueNode get(Identity id) {
            int cnt = this.mValueNodes.size();
            for (int i = 0; i < cnt; ++i) {
                if (!((ValueNode)this.mValueNodes.get(i)).hasID(id)) continue;
                return (ValueNode)this.mValueNodes.get(i);
            }
            return null;
        }

        int getCount() {
            return this.mValueNodes.size();
        }
    }
}

