/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.hqinsight.location;

import de.hardcode.hq.hqinsight.location.LocationNode;
import de.hardcode.hq.location.Location;
import de.hardcode.hq.location.LocationData;
import de.hardcode.hq.location.motion.DeadReckoner;
import de.hardcode.hq.location.motion.EulerMotion;
import de.hardcode.hq.location.motion.Motion;
import de.hardcode.hq.objectbus.BusStation;
import de.hardcode.time.Clock;
import edu.umd.cs.piccolo.activities.PActivity;
import java.awt.geom.Point2D;
import javax.vecmath.Vector3f;

public class UserControlledActivity
extends PActivity {
    private final LocationNode mNode;
    private final Location mLocation;
    private final BusStation mStation;
    private final Clock mClk;
    private boolean mInit = false;
    private long mLast = -1L;
    private float mSpeedX = 0.0f;
    private float mSpeedY = 0.0f;
    private double mAlpha = 0.0;
    private float mAcceleration = 0.0f;
    private double mSpin = 0.0;
    private static final float MAX_SPEED = 0.12f;
    private final Motion mRefMotion = new EulerMotion();
    private final DeadReckoner mDeadReckoner = new DeadReckoner(this.mRefMotion);
    private final LocationData mLocData = new LocationData();
    long lastsent = 0L;

    public UserControlledActivity(LocationNode node, Location loc, BusStation stat, Clock clk) {
        super(-1L, 50L, 0L);
        this.mNode = node;
        this.mLocation = loc;
        this.mStation = stat;
        this.mClk = clk;
        this.mLocation.getData(this.mLocData);
    }

    protected void activityStep(long elapsedTime) {
        super.activityStep(elapsedTime);
        long t = this.mClk.getCurrentTime();
        if (!this.mInit) {
            this.mInit = true;
            this.mLast = t;
            return;
        }
        long dt = t - this.mLast;
        this.mLast = t;
        double dalpha = this.mSpin * (double)dt;
        this.mAlpha += dalpha;
        float acc = 0.5f * this.mAcceleration * (float)dt * (float)dt;
        float dx = this.mSpeedX * (float)dt - acc * (float)Math.sin(this.mAlpha);
        float dy = this.mSpeedY * (float)dt - acc * (float)Math.cos(this.mAlpha);
        this.mSpeedX -= this.mAcceleration * (float)Math.sin(this.mAlpha) * (float)dt;
        this.mSpeedY -= this.mAcceleration * (float)Math.cos(this.mAlpha) * (float)dt;
        float totalspeed = (float)Math.sqrt(this.mSpeedX * this.mSpeedX + this.mSpeedY * this.mSpeedY);
        if (totalspeed > 0.12f) {
            float scale = 0.12f / totalspeed;
            this.mSpeedX *= scale;
            this.mSpeedY *= scale;
            this.mAcceleration = 0.0f;
        }
        Point2D pos = this.mNode.getOffset();
        pos.setLocation(pos.getX() + (double)dx, pos.getY() + (double)dy);
        this.mNode.setOffset(pos);
        this.mNode.rotate(-dalpha);
        this.updateLocation(t, dt);
    }

    void setAccelerate(float acc) {
        this.mAcceleration = acc;
    }

    void setSpin(double spin) {
        this.mSpin = spin;
    }

    private final void updateLocation(long time, long dt) {
        this.lastsent = time;
        Point2D pos2d = this.mNode.getOffset();
        this.mLocData.spin().set(0.0f, (float)this.mSpin, 0.0f);
        this.mLocData.velocity().set(this.mSpeedX, 0.0f, this.mSpeedY);
        this.mLocData.acceleration().set(0.0f, 0.0f, -this.mAcceleration);
        Vector3f trans = new Vector3f((float)pos2d.getX(), 0.0f, (float)pos2d.getY());
        this.mLocData.position().setIdentity();
        this.mLocData.position().rotY((float)this.mAlpha);
        this.mLocData.position().transform(this.mLocData.acceleration());
        this.mLocData.position().setTranslation(trans);
        this.mLocData.setTimeStamp(time);
        int what = this.mDeadReckoner.eval(this.mLocData, time, dt);
        if (what != 0) {
            this.mLocation.startUpdate(this);
            this.mLocation.setData(this.mLocData, what);
            this.mLocation.finishUpdate(time);
        }
        if (null != this.mStation) {
            this.mStation.flush();
        }
    }
}

