/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.hqinsight.location;

import de.hardcode.hq.hqinsight.ID;
import de.hardcode.hq.hqinsight.location.Controller;
import de.hardcode.hq.hqinsight.location.GridLayer;
import de.hardcode.hq.hqinsight.location.LocationControlledActivity;
import de.hardcode.hq.hqinsight.location.LocationNode;
import de.hardcode.hq.hqinsight.location.UserControlledActivity;
import de.hardcode.hq.identity.LongIdentity;
import de.hardcode.hq.location.Location;
import de.hardcode.hq.location.Locations;
import de.hardcode.hq.location.LocationsAdapter;
import de.hardcode.hq.location.client.LocationsClient;
import de.hardcode.hq.objectbus.BusStation;
import de.hardcode.time.Clock;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.event.PSelectionEventHandler;
import java.awt.Color;
import java.awt.Dimension;

public class LocationPanel
extends PCanvas {
    private final Locations mLocations;
    private final BusStation mStation;
    private final LocationsClient mClient;
    private final Clock mClk;
    private double mDimensionScale = 0.1;

    public LocationPanel(BusStation stat, Locations locs, Clock clk) {
        this.mStation = stat;
        this.mLocations = locs;
        this.mClk = clk;
        new GridLayer(this);
        this.setPreferredSize(new Dimension(400, 400));
        this.setBackground(Color.GREEN.darker().darker());
        PSelectionEventHandler selectionEventHandler = new PSelectionEventHandler((PNode)this.getLayer(), this.getLayer());
        this.addInputEventListener(selectionEventHandler);
        this.establishController(this.addLocationNode());
        this.mLocations.addListener(new LocationsAdapter(){

            public void created(Location which, Object initiator) {
                System.out.println("New Location created: " + which);
                if (initiator != LocationPanel.this) {
                    LocationPanel.this.establishLocationControlled(LocationPanel.this.addLocationNode(), which);
                }
            }
        });
        this.mClient = null != this.mStation ? new LocationsClient(this.mStation, ID.LOCATIONS, ID.LOCATIONS_SERVICE, locs) : null;
    }

    public void setDimensionScale(double scale) {
        this.mDimensionScale = scale;
        PLayer layer = this.getLayer();
        int n = layer.getChildrenCount();
        for (int i = 0; i < n; ++i) {
            PNode node = layer.getChild(i);
            if (!(node instanceof LocationNode)) continue;
            ((LocationNode)node).setDimensionScale(scale);
        }
        this.repaint();
    }

    LocationNode addLocationNode() {
        LocationNode n = new LocationNode();
        n.setDimensionScale(this.mDimensionScale);
        this.getLayer().addChild(n);
        return n;
    }

    void establishController(LocationNode n) {
        LongIdentity id = LongIdentity.createRandom(null);
        Location l = this.mLocations.createLocation(id, this);
        UserControlledActivity act = new UserControlledActivity(n, l, this.mStation, this.mClk);
        this.getLayer().addActivity(act);
        Controller c = new Controller(act);
        this.addInputEventListener(c);
        this.getRoot().getDefaultInputManager().setKeyboardFocus(c);
    }

    void establishLocationControlled(LocationNode n, Location l) {
        LocationControlledActivity act = new LocationControlledActivity(n, l, this.mClk);
        this.getLayer().addActivity(act);
    }
}

