/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.hqinsight.location;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class LocationNode
extends PNode {
    private double mDimensionScale = 0.1;

    public LocationNode() {
        this.setBounds(-4.0, -8.0, 8.0, 12.0);
        this.setPaint(Color.GREEN);
    }

    public void setDimensionScale(double scale) {
        this.mDimensionScale = scale;
    }

    public void setOffset(double x, double y) {
        super.setOffset(x * this.mDimensionScale, y * this.mDimensionScale);
    }

    public Point2D getOffset() {
        Point2D pos = super.getOffset();
        pos.setLocation(pos.getX() / this.mDimensionScale, pos.getY() / this.mDimensionScale);
        return pos;
    }

    protected void paint(PPaintContext paintContext) {
        float x = (float)this.getX();
        float y = (float)this.getY();
        float bottomY = (float)this.getHeight() + y;
        Graphics2D g2 = paintContext.getGraphics();
        g2.setPaint(this.getPaint());
        g2.drawOval(-3, -3, 6, 6);
        g2.drawLine(0, -7, 0, -3);
    }
}

