/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.hqinsight.location;

import de.hardcode.hq.hqinsight.location.LocationNode;
import de.hardcode.hq.location.Location;
import de.hardcode.hq.location.LocationData;
import de.hardcode.hq.location.motion.EulerMotion;
import de.hardcode.hq.location.motion.Motion;
import de.hardcode.time.Clock;
import edu.umd.cs.piccolo.activities.PActivity;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;

public class LocationControlledActivity
extends PActivity {
    private final LocationNode mNode;
    private final Location mLocation;
    private final Clock mClk;
    private boolean mInit = false;
    private long mLast = -1L;
    private float mSpeedX = 0.0f;
    private float mSpeedY = 0.0f;
    private double mAlpha = 0.0;
    private final Vector3f mVel = new Vector3f();
    private final Vector3f mSpin = new Vector3f();
    private final Matrix4f mPos = new Matrix4f();
    private final Vector3f mTrans = new Vector3f();
    private final Vector3f mAcc = new Vector3f();
    private final Vector3f LOOK_MINUS_Z = new Vector3f(0.0f, 0.0f, -1.0f);
    private final Motion mRefMotion = new EulerMotion();
    private final LocationData mLocData = new LocationData();

    public LocationControlledActivity(LocationNode node, Location loc, Clock clk) {
        super(-1L, 50L, 0L);
        this.mNode = node;
        this.mLocation = loc;
        this.mClk = clk;
    }

    protected void activityStep(long elapsedTime) {
        super.activityStep(elapsedTime);
        long t = this.mClk.getCurrentTime();
        if (!this.mInit) {
            this.mInit = true;
            this.mLast = t;
            return;
        }
        this.mLast = t;
        long dt = t - this.mLocation.getTimeStamp();
        this.mLocation.getData(this.mLocData);
        this.mRefMotion.move(this.mLocData, t, dt);
        this.mLocData.position().get(this.mTrans);
        this.mNode.setOffset(this.mTrans.x, this.mTrans.z);
        this.LOOK_MINUS_Z.x = 0.0f;
        this.LOOK_MINUS_Z.y = 0.0f;
        this.LOOK_MINUS_Z.z = -1.0f;
        this.mLocData.position().transform(this.LOOK_MINUS_Z);
        double alpha = Math.atan2(-this.LOOK_MINUS_Z.x, -this.LOOK_MINUS_Z.z);
        double dalpha = (alpha += (double)(this.mSpin.y * (float)dt)) - this.mAlpha;
        this.mAlpha += dalpha;
        this.mNode.rotate(-dalpha);
    }

    protected void activityStep2(long elapsedTime) {
        super.activityStep(elapsedTime);
        long t = this.mClk.getCurrentTime();
        if (!this.mInit) {
            this.mInit = true;
            this.mLast = t;
            return;
        }
        this.mLast = t;
        long dt = t - this.mLocation.getTimeStamp();
        this.mLocation.getVelocity(this.mVel);
        this.mLocation.getSpin(this.mSpin);
        this.mLocation.getAcceleration(this.mAcc);
        this.mLocation.getPosition(this.mPos);
        this.mPos.get(this.mTrans);
        float speedx = this.mVel.x + 0.5f * this.mAcc.x * (float)dt;
        float speedy = this.mVel.z + 0.5f * this.mAcc.z * (float)dt;
        float dx = speedx * (float)dt;
        float dy = speedy * (float)dt;
        this.mNode.setOffset(this.mTrans.x + dx, this.mTrans.z + dy);
        this.LOOK_MINUS_Z.x = 0.0f;
        this.LOOK_MINUS_Z.y = 0.0f;
        this.LOOK_MINUS_Z.z = -1.0f;
        this.mPos.transform(this.LOOK_MINUS_Z);
        double alpha = Math.atan2(-this.LOOK_MINUS_Z.x, -this.LOOK_MINUS_Z.z);
        double dalpha = (alpha += (double)(this.mSpin.y * (float)dt)) - this.mAlpha;
        this.mAlpha += dalpha;
        this.mNode.rotate(-dalpha);
    }
}

