/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.hqinsight;

import de.hardcode.hq.hqinsight.ChatPanel;
import de.hardcode.hq.hqinsight.ConnectDialog;
import de.hardcode.hq.hqinsight.ID;
import de.hardcode.hq.hqinsight.location.LocationMgrPanel;
import de.hardcode.hq.hqinsight.property.PropertyPanel;
import de.hardcode.hq.hqinsight.registry.RegistryPanel;
import de.hardcode.hq.location.Locations;
import de.hardcode.hq.objectbus.BusLine;
import de.hardcode.hq.objectbus.NetStation;
import de.hardcode.hq.property.Properties;
import de.hardcode.hq.registry.Registry;
import de.hardcode.hq.time.client.TimeClient;
import de.hardcode.time.Clock;
import de.hardcode.time.SystemClock;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;

public class HQInsight
extends JFrame {
    static final int SERVER_DEFAULT_PORT = 13664;
    NetStation mStation = new NetStation();
    BusLine mLine;
    Registry mRegistry;
    Locations mLocations;
    Properties mProperties;
    RegistryPanel mRegistryPanel;
    LocationMgrPanel mLocationPanel;
    PropertyPanel mPropertyPanel;
    ChatPanel mChatPanel;
    Clock mClk;
    private JTabbedPane mSubSystemsTabbedPane;

    public HQInsight(InetAddress adr, int port, String name) {
        this.mLine = this.mStation.createLine(adr, port);
        this.setupClient(name);
        this.setupGUI();
    }

    public HQInsight() {
        ConnectDialog dlg = new ConnectDialog((Frame)this, true, this.mStation);
        dlg.show();
        if (dlg.doExit()) {
            this.exitForm(null);
        }
        this.mLine = dlg.getLine();
        this.setupClient(dlg.getName());
        this.setupGUI();
    }

    private void setupGUI() {
        this.initComponents();
        this.mSubSystemsTabbedPane.add("Location", this.mLocationPanel);
        this.mSubSystemsTabbedPane.add("Chat", this.mChatPanel);
        this.mSubSystemsTabbedPane.add("Registry", this.mRegistryPanel);
        this.mSubSystemsTabbedPane.add("Property", this.mPropertyPanel);
        this.pack();
        Toolkit tk = this.getToolkit();
        Dimension d = tk.getScreenSize();
        this.setBounds(d.width / 3, d.height / 3, d.width / 3, d.height / 3);
    }

    private final void setupClient(String name) {
        if (null != this.mLine) {
            this.mStation.startReceive();
            this.mClk = new SystemClock();
            System.out.println("Current time of local clock:  " + this.mClk.getCurrentTime());
            System.out.println("Ping value from the server:   " + TimeClient.ping(this.mLine, ID.TIME_SERVICE, this.mClk));
            System.out.println("Adjusted time of local clock: " + this.mClk.getCurrentTime());
            this.mRegistry = new Registry();
            this.mRegistryPanel = new RegistryPanel(this.mStation, this.mRegistry);
            this.mChatPanel = new ChatPanel(this.mStation, name);
            this.mLocations = new Locations();
            this.mLocationPanel = new LocationMgrPanel(this.mStation, this.mLocations, this.mClk);
            this.mProperties = new Properties();
            this.mPropertyPanel = new PropertyPanel(this.mStation, this.mProperties);
        }
    }

    private void initComponents() {
        this.mSubSystemsTabbedPane = new JTabbedPane();
        this.setTitle("HQInsight");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                HQInsight.this.exitForm(evt);
            }
        });
        this.getContentPane().add((Component)this.mSubSystemsTabbedPane, "Center");
    }

    private void exitForm(WindowEvent evt) {
        if (null != this.mLine) {
            this.mRegistryPanel.close();
            this.mPropertyPanel.close();
            this.mChatPanel.close();
            this.mLine = null;
        }
        this.mStation.close();
        System.exit(0);
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            new HQInsight().show();
        } else {
            try {
                int port = 13664;
                InetAddress adr = InetAddress.getByName(args[0]);
                String name = args[1];
                System.out.println("Trying to connect to " + adr.getHostName());
                new HQInsight(adr, port, name).show();
            }
            catch (Exception e) {
                System.out.println("Failed to find host! Exception: " + e);
            }
        }
    }
}

