/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.hqinsight;

import de.hardcode.hq.objectbus.BusLine;
import de.hardcode.hq.objectbus.NetStation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ConnectDialog
extends JDialog {
    private BusLine mLine = null;
    private final NetStation mStation;
    private boolean mDoExit = true;
    private JTextField mServerTextField;
    private JButton mExitButton;
    private JTextField mNameTextField;
    private JPanel mButtonPanel;
    private JLabel mLabelServer;
    private JButton mOKButton;
    private JPanel mNamePanel;
    private JLabel mLabelName;
    private JPanel mServerPanel;

    public ConnectDialog(Frame parent, boolean modal, NetStation station) {
        super(parent, modal);
        this.mStation = station;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.mOKButton);
        Toolkit tk = this.getToolkit();
        Dimension d = tk.getScreenSize();
        Dimension my = this.getSize();
        this.setBounds((d.width - my.width) / 2, (d.height - my.height) / 2, my.width, my.height);
    }

    public BusLine getLine() {
        return this.mLine;
    }

    public String getName() {
        return this.mNameTextField.getText();
    }

    public boolean doExit() {
        return this.mDoExit;
    }

    private void initComponents() {
        this.mNamePanel = new JPanel();
        this.mLabelName = new JLabel();
        this.mNameTextField = new JTextField();
        this.mServerPanel = new JPanel();
        this.mLabelServer = new JLabel();
        this.mServerTextField = new JTextField();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mExitButton = new JButton();
        this.getContentPane().setLayout(new GridLayout(3, 1));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ConnectDialog.this.closeDialog(evt);
            }
        });
        this.mNamePanel.setLayout(new BorderLayout());
        this.mLabelName.setText("Name: ");
        this.mLabelName.setPreferredSize(new Dimension(50, 16));
        this.mNamePanel.add((Component)this.mLabelName, "West");
        this.mNameTextField.setText("MyName");
        this.mNameTextField.setPreferredSize(new Dimension(200, 20));
        this.mNamePanel.add((Component)this.mNameTextField, "Center");
        this.getContentPane().add(this.mNamePanel);
        this.mServerPanel.setLayout(new BorderLayout());
        this.mLabelServer.setText("Server: ");
        this.mLabelServer.setPreferredSize(new Dimension(50, 16));
        this.mServerPanel.add((Component)this.mLabelServer, "West");
        this.mServerTextField.setText("localhost");
        this.mServerTextField.setPreferredSize(new Dimension(200, 20));
        this.mServerPanel.add((Component)this.mServerTextField, "Center");
        this.getContentPane().add(this.mServerPanel);
        this.mOKButton.setText("OK");
        this.mOKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectDialog.this.mOKButtonActionPerformed(evt);
            }
        });
        this.mButtonPanel.add(this.mOKButton);
        this.mExitButton.setText("Exit");
        this.mExitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectDialog.this.mExitButtonActionPerformed(evt);
            }
        });
        this.mButtonPanel.add(this.mExitButton);
        this.getContentPane().add(this.mButtonPanel);
        this.pack();
    }

    private void mOKButtonActionPerformed(ActionEvent evt) {
        try {
            InetAddress adr = InetAddress.getByName(this.mServerTextField.getText());
            this.mLine = this.mStation.createLine(adr, 13664);
            if (null != this.mLine) {
                this.mDoExit = false;
                this.hide();
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        JOptionPane.showMessageDialog(this, "Could not connect to server!");
    }

    private void mExitButtonActionPerformed(ActionEvent evt) {
        this.mDoExit = true;
        this.hide();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

