/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.hqinsight;

import de.hardcode.hq.chat.client.ChatClient;
import de.hardcode.hq.chat.client.ChatListener;
import de.hardcode.hq.chat.client.ChatMessage;
import de.hardcode.hq.hqinsight.ID;
import de.hardcode.hq.objectbus.BusStation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ChatPanel
extends JPanel
implements ChatListener {
    private final ChatClient mChat;
    private final String mWhoTalks;
    private final BusStation mStation;
    private final vector mMessages = new vector();
    private JPanel mInputPanel;
    private JTextField mInputTextField;
    private JButton mSendButton;
    private JScrollPane mMessageScrollPane;
    private JList mMessageList;

    public ChatPanel(BusStation stat, String name) {
        this.mStation = stat;
        this.mWhoTalks = name;
        this.initComponents();
        this.mChat = new ChatClient(stat, ID.CHAT);
        this.mChat.addListener(this);
    }

    public void close() {
        this.mChat.close();
    }

    private void initComponents() {
        this.mInputPanel = new JPanel();
        this.mInputTextField = new JTextField();
        this.mSendButton = new JButton();
        this.mMessageScrollPane = new JScrollPane();
        this.mMessageList = new JList();
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(300, 200));
        this.mInputPanel.setLayout(new BorderLayout());
        this.mInputPanel.add((Component)this.mInputTextField, "Center");
        this.mSendButton.setText("Send");
        this.mSendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChatPanel.this.mSendButtonActionPerformed(evt);
            }
        });
        this.mInputPanel.add((Component)this.mSendButton, "East");
        this.add((Component)this.mInputPanel, "South");
        this.mMessageScrollPane.setViewportView(this.mMessageList);
        this.add((Component)this.mMessageScrollPane, "Center");
    }

    private void mSendButtonActionPerformed(ActionEvent evt) {
        String message = this.mInputTextField.getText();
        this.mInputTextField.setText("");
        this.addChatMsg("me", message);
        this.mChat.send(this.mWhoTalks, message);
        this.mStation.flush();
    }

    private final void addChatMsg(String who, String msg) {
        String m = who + " (" + DateFormat.getTimeInstance(2).format(new Date()) + "):  " + msg;
        this.mMessages.addElement(m);
        if (this.mMessages.size() > 1000) {
            this.mMessages.removeRange(0, 500);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChatPanel.this.mMessageList.setListData(ChatPanel.this.mMessages);
                ChatPanel.this.mMessageList.ensureIndexIsVisible(ChatPanel.this.mMessages.size() - 1);
            }
        });
    }

    public void newMessage(ChatMessage msg) {
        this.addChatMsg(msg.getSenderName(), msg.getMessage());
    }

    class vector
    extends Vector {
        vector() {
        }

        public void removeRange(int from, int to) {
            super.removeRange(from, to);
        }
    }
}

